//@author: vux
//@help: standard constant shader
//@tags: color
//@credits: 

float4x4 tW : WORLD;
float4x4 tV : VIEW;
float4x4 tWVP : WORLDVIEWPROJECTION;
float4x4 tVP : VIEWPROJECTION;
float4x4 tVI : VIEWINVERSE;

Texture2D texture2d;
Texture2D textureMaterial;

float4 c <bool color=true;>;
float radius = 0.05f;

float3 g_positions[4]:IMMUTABLE =
{
	float3( -1, 1, 0 ),
    float3( 1, 1, 0 ),
    float3( -1, -1, 0 ),
    float3( 1, -1, 0 ),
};
float2 g_texcoords[4]:IMMUTABLE = 
{ 
	float2(0,1), 
    float2(1,1),
    float2(0,0),
    float2(1,0),
};

SamplerState g_samLinear : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_IN
{
	//uint iv : SV_VertexID;
	float4 p: POSITION;	
	float3 n : NORMAL;
	float2 uv : TEXCOORD0;
};

struct VS_OUTPUT
{
	float3 cpoint : CPOINT;
	float3 norm : NORMAL;
	float2 uv : TEXCOORD0;
};

struct GS_OUT
{
	float4 pos : SV_Position;
	float4 color : COLOR0;
	float2 uv : TEXCOORD0;
};

struct HS_CONSTANT_OUTPUT
{
    float edges[3]        : SV_TessFactor;
    float inside[1]       : SV_InsideTessFactor;
};

struct HS_OUTPUT
{
    float3 cpoint : CPOINT;
	float3 norm : NORMAL;
	float2 uv : TEXCOORD0;
};

struct DS_OUTPUT
{
    float4 pos : POSITION;
	float3 norm : TEXCOORD0;
	float4 color : COLOR0;

};

VS_OUTPUT VS(VS_IN input)
{
    VS_OUTPUT res = (VS_OUTPUT)0;
    res.cpoint = input.p.xyz;
	res.norm = input.n;
	res.uv = input.uv;
    return res;
}

float factor = 1;

float minval = 0.1f;
float maxval = 500.0f;

float mintessel = 1.0f;
float maxtessel = 12.0f;

HS_CONSTANT_OUTPUT HSConst(InputPatch<VS_OUTPUT, 3> patch)
{
	
	float3 p1 = patch[0].cpoint;
	float3 p2 = patch[1].cpoint;
	float3 p3 = patch[2].cpoint;
	
	float3 edge1 = p2-p1;
	float3 edge2 = p3-p1;
	float3 norm = cross(edge1,edge2);
	float value = dot(norm,norm);
	

	float r = maxval - minval;
	float normalized = (value - minval) / r;
	float f = mintessel + normalized * (maxtessel - mintessel);
	f = min(f,maxtessel); f = max(f,mintessel);
	
    HS_CONSTANT_OUTPUT output;
	

    output.edges[0] = f;
    output.edges[1] =f;
	output.edges[2] = f;
	output.inside[0] =f;
	
    return output;
}

[domain("tri")]
[partitioning("fractional_even")]
[outputtopology("triangle_cw")]
[outputcontrolpoints(3)]
[patchconstantfunc("HSConst")]
HS_OUTPUT HS_I(InputPatch<VS_OUTPUT, 3> ip, uint id : SV_OutputControlPointID)
{
    HS_OUTPUT output;
    output.cpoint = ip[id].cpoint;
	output.norm = ip[id].norm;
	output.uv = ip[id].uv;
    return output;
}

[maxvertexcount(4)]
void GS(point DS_OUTPUT input[1], inout TriangleStream<GS_OUT> SpriteStream)
{
    GS_OUT output;
    
    for(int i=0; i<4; i++)
    {
        float3 position = g_positions[i]*radius;
        position = mul( position, (float3x3)tVI ) + input[0].pos.xyz;
    	float3 norm = input[0].norm;
        output.pos = mul( float4(position,1.0), tWVP );
        output.color = input[0].color;
        output.uv = g_texcoords[i];	
        SpriteStream.Append(output);
    }
    SpriteStream.RestartStrip();
}

[domain("tri")]
DS_OUTPUT DS(HS_CONSTANT_OUTPUT input, OutputPatch<HS_OUTPUT, 3> op, float3 uv : SV_DomainLocation)
{
    DS_OUTPUT output;
	
	float3 p = uv.x * op[0].cpoint 
        + uv.y * op[1].cpoint 
        + uv.z * op[2].cpoint;
	
	float3 n= uv.x * op[0].norm
        + uv.y * op[1].norm
        + uv.z * op[2].norm;
	
	float2 u = uv.x * op[0].uv
		+ uv.y  * op[1].uv
	  	+ uv.z * op[2].uv;

	n = normalize(n);

	output.norm= n;	
    output.pos =  float4(p.xyz,1);
	output.color = textureMaterial.SampleLevel(g_samLinear,u,0);
	
    return output;
}


float4 PS_Tex(GS_OUT In): SV_Target
{
    float4 col = texture2d.Sample( g_samLinear, In.uv)*In.color;
    return col*c;
}

technique10 Constant
{
	pass P0
	{
		
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetHullShader( CompileShader( hs_5_0, HS_I() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetGeometryShader( CompileShader( gs_4_0, GS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Tex() ) );
	}
}



