
// -----------------------------------------------------------------------------
// PARAMETERS:
// -----------------------------------------------------------------------------
//transforms
float4x4 tW: WORLD ;        //the models world matrix
float4x4 tV: VIEW ;         //view matrix as set via Renderer (EX9)
float4x4 tWV: WORLDVIEW ;
float4x4 tWVP: WORLDVIEWPROJECTION ;
float4x4 tP: PROJECTION ;   //projection matrix as set via Renderer (EX9)

float4 edges;
float2 inside;

struct VS_IN
{
	float3 cpoint : POSITION;
};

struct VS_OUTPUT
{
	float3 cpoint : CPOINT;
};

// -----------------------------------------------------------------------------
// VERTEX SHADER:
// -----------------------------------------------------------------------------

//Recall that the vertex shader is run once per control point. For this example, we just pass the control points through to the next stage.

VS_OUTPUT VS(VS_IN input)
{
    VS_OUTPUT output;
	//float4 posV = mul(float4(input.cpoint,1), tWV);
	
    output.cpoint = input.cpoint;
    return output;
}

// -----------------------------------------------------------------------------
// HULL SHADER:
// -----------------------------------------------------------------------------

//The patch constant function (HSConst below) is executed once per patch (a cubic curve in our case). Recall that the patch constant function must at least output tessellation factors. The control point function (HS below) is executed once per output control point. In our case, we just pass the control points through unmodified.

struct HS_CONSTANT_OUTPUT
{
    float edges[4]        : SV_TessFactor;
    float inside[2]       : SV_InsideTessFactor;
};

struct HS_OUTPUT
{
    float3 cpoint : CPOINT;
};

HS_CONSTANT_OUTPUT HSConst()
{
    HS_CONSTANT_OUTPUT output;

    output.edges[0] = edges.x;
    output.edges[1] = edges.y;
	output.edges[2] = edges.z;
	output.edges[3] = edges.w;
	output.inside[0] = inside.x;
	output.inside[1] = inside.y;

    return output;
}

[domain("quad")]
// "integer" / "fractional_even" / "fractional_odd"
[partitioning("integer")]
[outputtopology("triangle_cw")]
[outputcontrolpoints(1)]
[patchconstantfunc("HSConst")]
HS_OUTPUT HS_I(InputPatch<VS_OUTPUT, 1> ip, uint id : SV_OutputControlPointID)
{
    HS_OUTPUT output;
    output.cpoint = ip[id].cpoint;
    return output;
}

[domain("quad")]
// "integer" / "fractional_even" / "fractional_odd"
[partitioning("fractional_even")]
[outputtopology("triangle_cw")]
[outputcontrolpoints(1)]
[patchconstantfunc("HSConst")]
HS_OUTPUT HS_FE(InputPatch<VS_OUTPUT, 1> ip, uint id : SV_OutputControlPointID)
{
    HS_OUTPUT output;
    output.cpoint = ip[id].cpoint;
    return output;
}

[domain("quad")]
// "integer" / "fractional_even" / "fractional_odd"
[partitioning("fractional_odd")]
[outputtopology("triangle_cw")]
[outputcontrolpoints(1)]
[patchconstantfunc("HSConst")]
HS_OUTPUT HS_FO(InputPatch<VS_OUTPUT, 1> ip, uint id : SV_OutputControlPointID)
{
    HS_OUTPUT output;
    output.cpoint = ip[id].cpoint;
    return output;
}

[domain("quad")]
// "integer" / "fractional_even" / "fractional_odd"
[partitioning("pow2")]
[outputtopology("triangle_cw")]
[outputcontrolpoints(1)]
[patchconstantfunc("HSConst")]
HS_OUTPUT HS_P(InputPatch<VS_OUTPUT, 1> ip, uint id : SV_OutputControlPointID)
{
    HS_OUTPUT output;
    output.cpoint = ip[id].cpoint;
    return output;
}


// -----------------------------------------------------------------------------
// DOMAIN SHADER:
// -----------------------------------------------------------------------------


//Note that up until now, we have not used the cubic Bézier curve parametric function. The domain shader is where we use this function to compute the final position of the tessellated vertices.

struct DS_OUTPUT
{
    float4 position : SV_Position;
};

[domain("quad")]
DS_OUTPUT DS(HS_CONSTANT_OUTPUT input, OutputPatch<HS_OUTPUT, 1> op, float2 uv : SV_DomainLocation)
{
    DS_OUTPUT output;
	
	float3 p = float3(uv.x,uv.y,0.5);
	p -= 0.5;

	p += op[0].cpoint.xyz;

    //float t = uv.x;
	
	//float3 pos = pow(1.0f -t,2.0f) * op[0].cpoint + 2.0f * (1.0f - t) * op[1].cpoint * t + t* t  * op[2].cpoint;

    //float3 pos = pow(1.0f - t, 3.0f) * op[0].cpoint + 3.0f * pow(1.0f - t, 2.0f) * t * op[1].cpoint + 3.0f * (1.0f - t) * pow(t, 2.0f) * op[2].cpoint + pow(t, 3.0f) * op[3].cpoint;

    output.position = float4(p.xyz,1);// mul(float4(pos, 1.0f), tWVP);

    return output;
}


// -----------------------------------------------------------------------------
// PIXEL SHADER:
// -----------------------------------------------------------------------------

float4 PS(DS_OUTPUT input) : SV_Target0
{
    return float4(1.0f, 1.0f, 1.0f, 1.0f);
}

technique11 Integer
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS_I() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}

technique11 FractionalOdd
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS_FO() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}

technique11 FractionalEven
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS_FE() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}

technique11 Pow2
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS_P() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}



