#define HAS_UV 0

float4x4 tW : WORLD;
float4x4 tVP : VIEWPROJECTION;
float4x4 tWVP : WORLDVIEWPROJECTION;
float4x4 tWV : WORLDVIEW;

float factor;

Texture2D texture2d; 

SamplerState g_samLinear : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};


struct VS_Input
{
	float4 Position : POSITION;
	float3 Normal : NORMAL;
	#if HAS_UV > 0
	float2 Uv : TEXCOORD0;
	#endif
};

struct HS_Input
{
    float3 Position : POSITION;
    float3 Normal : NORMAL;
	#if HAS_UV > 0
	float2 Uv : TEXCOORD0;
	#endif
};

struct HS_ConstantOutput
{
    float fTessFactor[3]    : SV_TessFactor ;
    float fInsideTessFactor : SV_InsideTessFactor ;
    float3 f3B210    : POSITION3 ;
    float3 f3B120    : POSITION4 ;
    float3 f3B021    : POSITION5 ;
    float3 f3B012    : POSITION6 ;
    float3 f3B102    : POSITION7 ;
    float3 f3B201    : POSITION8 ;
    float3 f3B111    : CENTER ;
    float3 f3N110    : NORMAL3 ;      
    float3 f3N011    : NORMAL4 ;
    float3 f3N101    : NORMAL5 ;
};

struct HS_ControlPointOutput
{
    float3 Position    : POSITION ;
    float3 Normal      : NORMAL ;
	#if HAS_UV > 0
	float2 Uv : TEXCOORD0;
	#endif
};

struct DS_Output
{
    float4 Position   : SV_Position ;
    float3 Normal : TEXCOORD0;
	#if HAS_UV > 0
	float2 Uv : TEXCOORD1;
	#endif
};

struct PS_Input
{
    float4 Position   : SV_Position ;
    float3 Normal : TEXCOORD0;
	#if HAS_UV > 0
	float2 Uv : TEXCOORD1;
	#endif
};


HS_Input VS( VS_Input input )
{
    HS_Input O;  
    O.Position = input.Position.xyz;
    O.Normal = input.Normal;
	
	#if HAS_UV > 0
		O.Uv = input.Uv;
	#endif
	
    return O;    
}


PS_Input VS_Simple( VS_Input input )
{
    PS_Input O;  
    O.Position = mul(input.Position,tWVP);
    O.Normal = mul(float4(input.Normal,0.0f),tWV).xyz;
	
	#if HAS_UV > 0
		O.Uv = input.Uv;
	#endif
    return O;    
}

HS_ConstantOutput HS_PNTrianglesConstant( InputPatch<HS_Input, 3> I )
{
    HS_ConstantOutput O = (HS_ConstantOutput)0;
	O.fTessFactor[0] = factor;    
    O.fTessFactor[1] = factor;    
    O.fTessFactor[2] = factor;   
    O.fInsideTessFactor = ( O.fTessFactor[0] + O.fTessFactor[1] + O.fTessFactor[2] ) / 3.0f;  
		
	    float3 f3B003 = I[0].Position;
        float3 f3B030 = I[1].Position;
        float3 f3B300 = I[2].Position;
        // And Normals
        float3 f3N002 = I[0].Normal;
        float3 f3N020 = I[1].Normal;
        float3 f3N200 = I[2].Normal;

    	O.f3B210 = ( ( 2.0f * f3B003 ) + f3B030 - ( dot( ( f3B030 - f3B003 ), f3N002 ) * f3N002 ) ) / 3.0f;
   		O.f3B120 = ( ( 2.0f * f3B030 ) + f3B003 - ( dot( ( f3B003 - f3B030 ), f3N020 ) * f3N020 ) ) / 3.0f;
        O.f3B021 = ( ( 2.0f * f3B030 ) + f3B300 - ( dot( ( f3B300 - f3B030 ), f3N020 ) * f3N020 ) ) / 3.0f;
        O.f3B012 = ( ( 2.0f * f3B300 ) + f3B030 - ( dot( ( f3B030 - f3B300 ), f3N200 ) * f3N200 ) ) / 3.0f;
        O.f3B102 = ( ( 2.0f * f3B300 ) + f3B003 - ( dot( ( f3B003 - f3B300 ), f3N200 ) * f3N200 ) ) / 3.0f;
        O.f3B201 = ( ( 2.0f * f3B003 ) + f3B300 - ( dot( ( f3B300 - f3B003 ), f3N002 ) * f3N002 ) ) / 3.0f;

        float3 f3E = ( O.f3B210 + O.f3B120 + O.f3B021 + O.f3B012 + O.f3B102 + O.f3B201 ) / 6.0f;
        float3 f3V = ( f3B003 + f3B030 + f3B300 ) / 3.0f;
        O.f3B111 = f3E + ( ( f3E - f3V ) / 2.0f );
        
        float fV12 = 2.0f * dot( f3B030 - f3B003, f3N002 + f3N020 ) / dot( f3B030 - f3B003, f3B030 - f3B003 );
        O.f3N110 = normalize( f3N002 + f3N020 - fV12 * ( f3B030 - f3B003 ) );
        float fV23 = 2.0f * dot( f3B300 - f3B030, f3N020 + f3N200 ) / dot( f3B300 - f3B030, f3B300 - f3B030 );
        O.f3N011 = normalize( f3N020 + f3N200 - fV23 * ( f3B300 - f3B030 ) );
        float fV31 = 2.0f * dot( f3B003 - f3B300, f3N200 + f3N002 ) / dot( f3B003 - f3B300, f3B003 - f3B300 );
        O.f3N101 = normalize( f3N200 + f3N002 - fV31 * ( f3B003 - f3B300 ) );
    return O;
}

[domain("tri")]
[partitioning("fractional_odd")]
[outputtopology("triangle_cw")]
[patchconstantfunc("HS_PNTrianglesConstant")]
[outputcontrolpoints(3)]
HS_ControlPointOutput HS( InputPatch<HS_Input, 3> I, uint uCPID : SV_OutputControlPointID )
{
    HS_ControlPointOutput O = (HS_ControlPointOutput)0;
    O.Position = I[uCPID].Position;
    O.Normal = I[uCPID].Normal; 
	
	#if HAS_UV > 0
		O.Uv = I[uCPID].Uv;
	#endif
	
    return O;
}

[domain("tri")]
DS_Output DS( HS_ConstantOutput HSConstantData, const OutputPatch<HS_ControlPointOutput, 3> I, float3 f3BarycentricCoords : SV_DomainLocation )
{
    DS_Output O = (DS_Output)0;

    float fU = f3BarycentricCoords.x;
    float fV = f3BarycentricCoords.y;
    float fW = f3BarycentricCoords.z;

    float fUU = fU * fU;
    float fVV = fV * fV;
    float fWW = fW * fW;
    float fUU3 = fUU * 3.0f;
    float fVV3 = fVV * 3.0f;
    float fWW3 = fWW * 3.0f;
    
    float3 f3Position = I[0].Position * fWW * fW +
                        I[1].Position * fUU * fU +
                        I[2].Position * fVV * fV +
                        HSConstantData.f3B210 * fWW3 * fU +
                        HSConstantData.f3B120 * fW * fUU3 +
                        HSConstantData.f3B201 * fWW3 * fV +
                        HSConstantData.f3B021 * fUU3 * fV +
                        HSConstantData.f3B102 * fW * fVV3 +
                        HSConstantData.f3B012 * fU * fVV3 +
                        HSConstantData.f3B111 * 6.0f * fW * fU * fV;
	    
    float3 f3Normal =   I[0].Normal * fWW +
                        I[1].Normal * fUU +
                        I[2].Normal * fVV +
                        HSConstantData.f3N110 * fW * fU +
                        HSConstantData.f3N011 * fU * fV +
                        HSConstantData.f3N101 * fW * fV;
	
	
	
    // Normalize the interpolated normal    
    f3Normal = normalize( -f3Normal );

    O.Position = mul( float4( f3Position.xyz, 1.0 ), tWVP);
	O.Normal = -f3Normal;//mul(float4(f3Normal,0.0f),tW);
	
	#if HAS_UV > 0
		O.Uv = I[0].Uv * fW + I[1].Uv * fU + I[2].Uv * fV;
	#endif
	
   
    return O;
}

float4 PS( PS_Input I ) : SV_Target
{
	#if HAS_UV > 0
		float4 c = texture2d.Sample(g_samLinear,I.Uv);
	#else
		float4 c = float4(I.Normal * 0.5 + 0.5,1.0f);
	#endif

	return c;
}

technique11 RenderNoTesselation
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, VS_Simple() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}

technique11 Render
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetHullShader( CompileShader( hs_5_0, HS()) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}



