struct BoundingBox
{
	float3 bmin;
	float3 bmax;
};

struct Box
{
	float3 vertices[8];
};

Box GetBox(BoundingBox b, float4x4 w)
{
	float3 minb = mul(float4(b.bmin,1.0f),w).xyz;
	float3 maxb = mul(float4(b.bmax,1.0f),w).xyz;
	
	Box res;
	res.vertices[0] = float3(minb.x,minb.y,minb.z);
	res.vertices[1] = float3(maxb.x,minb.y,minb.z);
	res.vertices[2] = float3(minb.x,maxb.y,minb.z);
	res.vertices[3] = float3(maxb.x,maxb.y,minb.z);
	res.vertices[4] = float3(minb.x,minb.y,maxb.z);
	res.vertices[5] = float3(maxb.x,minb.y,maxb.z);
	res.vertices[6] = float3(minb.x,maxb.y,maxb.z);
	res.vertices[7] = float3(maxb.x,maxb.y,maxb.z);
	
	return res;
}

float DistanceFromPlane (float3 f3Position,float4 f4PlaneEquation)
{ 
    float fDistance = dot( float4( f3Position, 1.0f ), f4PlaneEquation );
    
    return fDistance;
}

bool ViewFrustumCullPoint(float3 p,float4 f4ViewFrustumPlanes[6],float fCullEpsilon)
{    
    float4 f4PlaneTest;

    f4PlaneTest.x = DistanceFromPlane( p, f4ViewFrustumPlanes[0]) > -fCullEpsilon  ? 1.0f : 0.0f ;
    f4PlaneTest.y = DistanceFromPlane( p, f4ViewFrustumPlanes[1]) >-fCullEpsilon  ? 1.0f : 0.0f ;
	f4PlaneTest.z = DistanceFromPlane( p, f4ViewFrustumPlanes[2]) >-fCullEpsilon  ? 1.0f : 0.0f ;
	f4PlaneTest.w = DistanceFromPlane( p, f4ViewFrustumPlanes[3]) > -fCullEpsilon  ? 1.0f : 0.0f ;
	
	float2 fpLast;
	fpLast.x = DistanceFromPlane( p, f4ViewFrustumPlanes[4]) > -fCullEpsilon  ? 1.0f : 0.0f ;
    fpLast.y = DistanceFromPlane( p, f4ViewFrustumPlanes[5]) > -fCullEpsilon  ? 1.0f : 0.0f ;

    return !any( f4PlaneTest ) && !any(fpLast);
}

bool ViewFrustumCull(BoundingBox b, float4x4 w,float4 f4ViewFrustumPlanes[6],float fCullEpsilon)
{
	Box bo = GetBox(b,w);
   
	bool res = false; 
	for (int i = 0; i < 8; i++)
	{
		res = res || ViewFrustumCullPoint(bo.vertices[i],f4ViewFrustumPlanes,fCullEpsilon);
	}
	
	return res;
	
} 

