struct VSIn
{
    float3 pos  : POSITION; 
	float3 norm  : NORMAL;
	float2 texcoord : TEXCOORD0;
};

VSIn PassTroughVS(VSIn input)
{
	VSIn o;
	o.pos = input.pos;
	o.norm =  input.norm;
	o.texcoord = input.texcoord;
  	return o;
} 

void AppendTri(inout VSIn o,float3 p1,float3 p2,float3 p3,inout TriangleStream<VSIn> gsout)
{
	float3 faceEdgeA = p2 - p1;
    float3 faceEdgeB = p1 -p3;
    float3 norm = cross(faceEdgeB, faceEdgeA);	
	norm = normalize(norm);
	
	o.norm = norm;
	o.texcoord = 0;
	o.pos = p1;
	gsout.Append(o);
	o.pos = p2;
	gsout.Append(o);
	o.pos = p3;
	gsout.Append(o);
	gsout.RestartStrip();
}
