//@author: vvvv group
//@help: draws a mesh with a constant color
//@tags: template, basic
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (EX9)
float4x4 tVP: VIEWPROJECTION;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 matVI: VIEWINVERSE;

//material properties

//texture
texture lTex <String uiname="Light Data";>;
sampler lSamp = sampler_state
{
    Texture   = (lTex);          //apply a texture to the sampler
    MipFilter = POINT;         //sampler states
    MinFilter = POINT;
    MagFilter = POINT;
};
const int lsamples <String uiname="Light Count"; int uimin=1;> = 2;
const int lindex <String uiname="Main Light Index"; int uimin=0;> = 0;
texture lpTex <String uiname="Attenuation/Power";>;
sampler lpSamp = sampler_state
{
    Texture   = (lpTex);          //apply a texture to the sampler
    MipFilter = POINT;         //sampler states
    MinFilter = POINT;
    MagFilter = POINT;
};
texture cTex <string uiname="Color texture";>;
sampler cSamp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (cTex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
texture pTex <string uiname="Position";>;
sampler pSamp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (pTex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
texture nTex <string uiname="Normal";>;
sampler nSamp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (nTex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
texture ambTex <String uiname="Ambient Texture";>;
sampler ambSamp = sampler_state
{
    Texture   = (ambTex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
texture emTex <String uiname="Emission Texture";>;
sampler emSamp = sampler_state
{
    Texture   = (emTex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
texture specMap <String uiname="Specular Map";>;
sampler specSamp = sampler_state
{
    Texture   = (specMap);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
texture ShadT <String uiname="Shadow Pass";>;
sampler shadSamp = sampler_state
{
    Texture   = (ShadT);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
bool shadeAll <String uiname="Shade all lights";> = 0;
float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;
float lAtt2 <String uiname="Light Attenuation 2"; float uimin=0.0;> = 0;
float dmod = 1;

//phong point function
float3 PhongPoint(float3 PosW, float3 NormV, float3 ViewDirV, float shadow, float2 TexCd)
{
	float4 props = tex2D(lpSamp, TexCd);
	float lAtt0 = props.r;
	float lAtt1 = props.g;
	float lPower = props.b;
	
	float4 lAmb = tex2D(ambSamp, TexCd);
	float4 lEm = tex2D(emSamp, TexCd);
	float4 lDiff = tex2D(cSamp, TexCd);
	float4 lSpec = tex2D(specSamp, TexCd);
	
    float3 outCol = 0;
	for(float i=0; i<lsamples; i++)
    {
        float index = i/lsamples;
        float4 lDat1 = tex2D(lSamp, float2(index+0.5/lsamples, .25));
        float4 lDat2 = tex2D(lSamp, float2(index+0.5/lsamples, .75));

        float3 lPos = lDat1.xyz;
        float lRange = lDat1.w;
        float3 lCol = lDat2.xyz * lDat2.w;

        float d = distance(PosW, lPos);
        float atten = 0;
        float3 amb=0;
        float3 diff = 0;
        float3 spec = 0;
    	
        atten = 1/(saturate(lAtt0) + saturate(lAtt1) * d + saturate(lAtt2) * pow(d, 2));
        	
        amb = lAmb.rgb * atten;

        if((d<lRange) && (!(((i==lindex) || shadeAll) && (shadow==0))))
        {

            float3 LightDirW = normalize(lPos - PosW);
            float3 LightDirV = mul(LightDirW, tV);

            //halfvector
            float3 H = normalize(ViewDirV + LightDirV);
            //compute blinn lighting
            float3 shades = lit(dot(NormV, LightDirV), dot(NormV, H), lPower);
            diff = lDiff.rgb * lCol * shades.y * atten;
            //reflection vector (view space)
            float3 R = normalize(2 * dot(NormV, LightDirV) * NormV - LightDirV);
            //normalized view direction (view space)
            float3 V = normalize(ViewDirV);
            //calculate specular light
            spec = pow(max(dot(R, V),0), lPower*.2) * lSpec.rgb * lCol;
        }
        outCol += (diff + spec) * pow(saturate((lRange-d)/lRange),dmod);
    	outCol += amb/lsamples;
        if((i==lindex) || shadeAll) outCol *= shadow;
    }
    //outCol *= tex2D(diffSamp, TexCd).rgb;
    outCol += lEm.rgb;
    return outCol;
}

//the data structure: vertexshader to pixelshader
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos : POSITION;
    float4 TexCd : TEXCOORD0;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
    float4 Pos : POSITION,
    float4 TexCd : TEXCOORD0)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

    //transform position
    Out.Pos = Pos*2;
	Out.Pos.w = 1;

    //transform texturecoordinates
    Out.TexCd = mul(TexCd, tTex);

    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(vs2ps In): COLOR
{
    //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0
	float4 col = float4(0,0,0,1);
	float4 inPosWV = tex2D(pSamp, In.TexCd);
	float4 inPosW = mul(tex2D(pSamp, In.TexCd),matVI);
	float4 inNorm = tex2D(nSamp, In.TexCd);
	float shad = tex2D(shadSamp, In.TexCd).r;
	float4 cvr = tex2D(lpSamp, In.TexCd);
	if((cvr.r==0) && (cvr.g==0) && (cvr.b==0))
	{
		return tex2D(cSamp, In.TexCd);
	}
	else
	{
		col.rgb = PhongPoint(inPosW.rgb, inNorm.rgb, -normalize(inPosWV.rgb), shad, In.TexCd.xy);
		return col;
	}
	
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TConstant
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS();
    }
}