//@author: vvvv group
//@help: draws a mesh with a constant color
//@tags: template, basic
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (EX9)
float4x4 tVP: VIEWPROJECTION;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 matVI: VIEWINVERSE;

//material properties

//texture
texture pTex <string uiname="Position";>;
sampler pSamp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (pTex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

texture TexMap <string uiname="ShadowMap";>;
samplerCUBE smap = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexMap);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
texture loTx <string uiname="Light Offset";>;
sampler lightOffset = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (loTx);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
texture nTx <string uiname="Noise";>;
sampler noiseSamp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (nTx);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;

float bias <string uiname="Shadow Bias";> = 0.02;
float contrast <string uiname="Contrast";> = 5;
const int samples <string uiname="Samples";> = 3;
float softness <string uiname="Softness";> = 0;
float blurring <string uiname="Softness Distance Multiplier";> = 1;
float epsilon = 0.05;
float noiseAmount = 0;
float3 LightPos = 0;

//the data structure: vertexshader to pixelshader
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos : POSITION;
    float4 TexCd : TEXCOORD0;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
    float4 Pos : POSITION,
    float4 TexCd : TEXCOORD0)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

    //transform position
    Out.Pos = float4(Pos.xyz*2, Pos.w);

    //transform texturecoordinates
    Out.TexCd = mul(TexCd, tTex);

    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(vs2ps In): COLOR
{
    //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0
	float4 inPosWV = tex2D(pSamp, In.TexCd);
	float4 inPosW = mul(tex2D(pSamp, In.TexCd),matVI);
	
	float4 col = float4(0,0,0,1);

	float3 pp1 = inPosW;
	float3 pp2 = pp1 - LightPos;
	float pdist1 = texCUBE(smap, normalize(pp2)).x;
    float pdist2 = length(pp2);
	float dd = pdist2 - pdist1;
	col.g = dd;

	col.r = 1;
	for(float i=0; i<samples; i++) {
		float3 offs = tex2D(lightOffset, float2(i/samples, 0.5)).rgb;
		float3 noise = 0;
		if(noiseAmount!=0) noise = (tex2D(noiseSamp, float2(In.TexCd.x + (i/samples)*.05, In.TexCd.y)).rgb-0.5) * noiseAmount*(pdist2*blurring*6);
		float3 p1 = inPosW + offs * (pdist2*blurring) + noise;
		float3 p2 = p1 - LightPos;
		float dist1 = texCUBE(smap, normalize(p2)).z;
    	float dist2 = length(p2);
		//float tmp = ((dist2-bias) > dist1);
		float tmp = min(max((dist2-dist1)/contrast-bias,0),1);
		col.r -= tmp/samples;
	}

    return max(0,min(1,col));
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TConstant
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS();
    }
}