#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
using SlimDX;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Integral", Category = "Transform", Help = "Basic template with one transform in/out", Tags = "matrix")]
	#endregion PluginInfo
	public class TransformIntegralNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input")]
		public ISpread<Matrix> FInput;
		
		[Input("Repeat")]
		public ISpread<Matrix> FRepeat;
		
		[Input("Count")]
		public ISpread<int> FCount;

		[Output("Output")]
		public ISpread<Matrix> FOutput;

		[Import()]
		public ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			this.FOutput.SliceCount = FCount[0];
			
			Matrix initial = FInput[0];
			for (int i = 0; i < FCount[0]; i++)
			{
				FOutput[i] = initial;
				initial*= FRepeat[i];
			}
		}
	}
}
