#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;

using VVVV.DX11;
using SlimDX;
using FeralTic.DX11;
using SlimDX.Direct3D11;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "CustomLayer", Category = "DX11", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class DX11CustomLayerNode : IPluginEvaluate, IDX11LayerHost
	{
		[Input("Layer In")]
        protected Pin<DX11Resource<DX11Layer>> FLayerIn;
		
		[Input("Slice From")]
		public ISpread<int> FSliceFrom;
		
		[Input("Viewport To")]
		public ISpread<int> FViewportTo;
		
		[Input("Viewports")]
		public ISpread<Viewport> FViewports;
		
		[Input("Enabled",DefaultValue=1, Order = 100000)]
        protected IDiffSpread<bool> FEnabled;
		
        [Output("Layer Out")]
        protected ISpread<DX11Resource<DX11Layer>> FOutLayer;

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if (this.FOutLayer[0] == null) 
			{ 
				this.FOutLayer[0] = new DX11Resource<DX11Layer>(); 
			}
		}
		 
		public void Update(DX11RenderContext context)
		{
            if (!this.FOutLayer[0].Contains(context))
            {
                this.FOutLayer[0][context] = new DX11Layer();
                this.FOutLayer[0][context].Render = this.Render;
            }
		}
		
        private void Render(DX11RenderContext context, DX11RenderSettings settings)
        {
            if (this.FEnabled[0])
            {   
            	if (this.FLayerIn.IsConnected)
                {
	            	int mx = SpreadUtils.SpreadMax(this.FSliceFrom, this.FViewportTo);
	            	
	            	for (int i = 0; i < mx; i++)
	            	{
	            		int slice = this.FSliceFrom[i];
	            		Viewport viewport = this.FViewports[this.FViewportTo[i]];
	            		
	            		//Viewport viewport = this.FViewports[1];
	            		
	            		context.RenderTargetStack.PushViewport(viewport);
	            		
	            		this.FLayerIn[slice][context].Render(context, settings);
	            		
	            		context.RenderTargetStack.Pop();
	            	}
                }
            }
            else
            {
                if (this.FLayerIn.IsConnected)
                {
                     this.FLayerIn.RenderAll(context, settings);
                }
            }
        }
		
		public void Destroy(DX11RenderContext context, bool force)
		{
			
		}
	}
}
