using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using SlimDX;
using VVVV.Core.Logging;
using VVVV.DX11;

namespace VVVV.Nodes
{
	[PluginInfo(Name = "WithinSphere", Category = "DX11.Validator", Help = "Basic template with one value in/out", Tags = "")]
	public class DX11_ValidatorWithinSphereNode : IPluginEvaluate
	{
		public class WithinSphereValidator : IDX11ObjectValidator
		{
        	public bool Enabled {get;set;}
			public BoundingSphere BoundingSphere;

        	public void SetGlobalSettings(DX11RenderSettings settings)
        	{
        	}

	        public bool Validate(DX11ObjectRenderSettings obj)
	        {
	        	if (obj.Geometry.HasBoundingBox == false)
	        		return true;
	        	
	        	Matrix worldMatrix = obj.WorldTransform;
	        	BoundingBox boundingBox = obj.Geometry.BoundingBox;
	            boundingBox.Maximum = Vector3.TransformCoordinate(boundingBox.Maximum, worldMatrix);
	            boundingBox.Minimum = Vector3.TransformCoordinate(boundingBox.Minimum, worldMatrix);
	        	return BoundingSphere.Contains(this.BoundingSphere, boundingBox) != ContainmentType.Contains;
	        }

		    public void Reset()
		    {
		    }
		}
		

		
		[Input("Center", DefaultValue = 0.0)]
		public ISpread<Vector3> FInput;
		
		[Input("Radius", DefaultValue = 0.5)]
		public ISpread<float> FRadius;
		
		[Input("Enabled", DefaultValue = 1)]
        protected ISpread<bool> FInEnabled;

		[Output("Output")]
		public ISpread<WithinSphereValidator> FOutput;

		public void Evaluate(int SpreadMax)
		{
            if (this.FOutput[0] == null) { this.FOutput[0] = new WithinSphereValidator(); }
            this.FOutput[0].Enabled = this.FInEnabled[0];
            this.FOutput[0].BoundingSphere = new BoundingSphere(this.FInput[0], this.FRadius[0]);
            this.FOutput[0].Reset();
		}
	}
}
