cbuffer cbPerDraw : register( b0 )
{
	float4 color <bool color =true;> = 1;
	float4x4 tVP : VIEWPROJECTION;
	float4x4 tV : VIEW;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

struct vsInput
{
	float4 pos : POSITION;
	float3 norm : NORMAL;
};

struct psInput
{
    float4 pos: SV_Position;
	float3 norm : NORMAL;
};

vsInput VS(vsInput input)
{
	return input;
}

float openFactor = 0.0f;

void Append(float3 p, float3 n, inout TriangleStream<psInput> gsout)
{
	psInput output;
	output.pos = mul(float4(p, 1.0f), mul(tW,tVP));
	output.norm = mul(float4(n, 0.0f), mul(tW,tV)).xyz;
	gsout.Append(output);
}

[maxvertexcount(8)]
void GS(triangle vsInput input[3], inout TriangleStream<psInput> gsout)
{
	psInput output;
	
	float3 p1 = input[0].pos.xyz;
	float3 p2 = input[1].pos.xyz;
	float3 p3 = input[2].pos.xyz;
	
	float3 n1 = input[0].norm.xyz;
	float3 n2 = input[1].norm.xyz;
	float3 n3 = input[2].norm.xyz;
	
	
	float3 ce = (p1 + p2 + p3) / 3.0f;
	
	float3 pc1 = lerp(ce, p1, openFactor);
	float3 pc2 = lerp(ce, p2, openFactor);
	float3 pc3 = lerp(ce, p3, openFactor);
	
	Append(pc1,n1,gsout);
	Append(p1,n1,gsout);
	
	Append(pc2,n2,gsout);
	Append(p2,n2,gsout);
		
	Append(pc3,n3,gsout);
	Append(p3,n3,gsout);
	
	Append(pc1,n1,gsout);
	Append(p1,n1,gsout);
}


float4 PS(psInput input): SV_Target
{
    return color;
}


technique10 Render
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetGeometryShader(CompileShader(gs_4_0,GS()));
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}



