cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

struct vsInput
{
	float4 pos : POSITION;
	float3 norm : NORMAL;
};

struct psInput
{
    float4 pos: SV_Position;
	float3 norm : NORMAL;
};

psInput VS(vsInput input)
{
	psInput output;
	output.pos = mul(input.pos,mul(tW,tVP));
	output.norm = input.norm;
	return output;
}


float4 PS(psInput input): SV_Target
{
    return float4(input.norm,1);
}


technique10 ShowCase
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




