//@author: vux
//@help: use clipplane Vertex Shader attribute
//@tags: color
//@credits: 

struct vsInput
{
    float4 posObject : POSITION;
};

struct psInput
{
    float4 posScreen : SV_Position;
	float clipDistance : SV_ClipDistance;
};

cbuffer cbPerDraw : register(b0)
{
	float4x4 tVP : LAYERVIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

cbuffer cbClipPlane
{
	float4 myClipPlane;
}

psInput VS(vsInput input)
{
	psInput output;
	output.posScreen = mul(input.posObject,mul(tW,tVP));
	output.clipDistance = dot(input.posObject , myClipPlane);
	return output;
}

float4 PS(psInput input): SV_Target
{
    return 1;
}

technique11 Apply
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}





