float sdPlane(float3 pos, float4 plane)
{
	return dot(pos,plane.xyz) + plane.w;
}

bool rayPlane(float3 rayPos, float3 rayDir,float4 plane, out float dist)
{
	float direction = dot(plane.xyz, rayDir);
	if (abs(direction) < 0.000001f)
	{
		return false;
	}

    float position = dot(plane.xyz, rayPos);
    dist = (-plane.w - position) / direction;

    if (dist < 0.0f)
    {
    	dist = 0.0f;
        return false;
    }

    return true;
}

float4 Plane = float4(0,1,0,1);

cbuffer cbPerDraw : register( b0 )
{
	float4 col[4] <bool color=true;>;
	float4x4 tVP : VIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

struct vsInput
{
	float4 pos : POSITION;
};

struct psInput
{
    float4 pos: SV_Position;
	float4 color : COLOR;
};

vsInput VS(vsInput input)
{
	return input;
}

[maxvertexcount(4)]
void GS_Case(triangle vsInput input[3], inout TriangleStream<psInput> gsout)
{
	psInput output;
	
	float3 dists;
	dists.x = sdPlane(input[0].pos.xyz, Plane);
	dists.y = sdPlane(input[1].pos.xyz, Plane);
	dists.z = sdPlane(input[2].pos.xyz, Plane);
	
	float3 sides = dists > 0.0f;
	
	float count = sides.x + sides.y + sides.z;
	
	output.color = col[count];
	for (int i = 0; i < 3; i++)
	{
		float4 p = input[i].pos;
		
		output.pos = mul(p, mul(tW,tVP));
		gsout.Append(output);
	}
}

[maxvertexcount(4)]
void GS_Slice(triangle vsInput input[3], inout TriangleStream<psInput> gsout)
{
	psInput output;
	
	float3 dists;
	dists.x = sdPlane(input[0].pos.xyz, Plane);
	dists.y = sdPlane(input[1].pos.xyz, Plane);
	dists.z = sdPlane(input[2].pos.xyz, Plane);
	
	float3 sides = dists > 0.0f;
	
	float count = sides.x + sides.y + sides.z;
	
	output.color = 1;
	
	if (count == 3)
	{
		for (int i = 0; i < 3; i++)
		{
			float4 p = input[i].pos;
			output.pos = mul(p, mul(tW,tVP));
			gsout.Append(output);
		}		
	}

	if (count == 2)
	{
		uint belowidx = sides.x == 0 ? 0 : (sides.y == 0 ? 1 : 2);
		uint other1 = (belowidx + 1) % 3;
		uint other2 = (belowidx + 2) % 3;
		
		float3 rayPos = input[belowidx].pos.xyz;
		
		float3 rayDir1 = normalize(input[other1].pos.xyz - rayPos);
		float3 rayDir2 = normalize(input[other2].pos.xyz - rayPos);
		
		float d1,d2;
		rayPlane(rayPos,rayDir1,Plane, d1);
		rayPlane(rayPos,rayDir2,Plane, d2);
		
		
		float3 p2 = rayPos + rayDir1 * d1;
		float3 p3 = rayPos + rayDir2 * d2;
		
		output.pos = mul(float4(input[other1].pos.xyz,1.0f), mul(tW,tVP));
		gsout.Append(output);
		
		output.pos = mul(float4(input[other2].pos.xyz,1.0f), mul(tW,tVP));
		gsout.Append(output);

		output.pos = mul(float4(p2,1.0f), mul(tW,tVP));
		gsout.Append(output);
		
		output.pos = mul(float4(p3,1.0f), mul(tW,tVP));
		gsout.Append(output);

		gsout.RestartStrip();
	}
	
	if (count == 1)
	{
		//Find the vertex above our plane
		uint aboveidx = sides.x > 0 ? 0 : (sides.y > 0 ? 1 : 2);
		uint other1 = (aboveidx + 1) % 3;
		uint other2 = (aboveidx + 2) % 3;
		
		float3 rayPos = input[aboveidx].pos.xyz;
		
		float3 rayDir1 = normalize(input[other1].pos.xyz - rayPos);
		float3 rayDir2 = normalize(input[other2].pos.xyz - rayPos);
		
		float d1,d2;
		rayPlane(rayPos,rayDir1,Plane, d1);
		rayPlane(rayPos,rayDir2,Plane, d2);
		
		float3 p2 = rayPos + rayDir1 * d1;
		float3 p3 = rayPos + rayDir2 * d2;
		
		output.pos = mul(float4(rayPos,1.0f), mul(tW,tVP));
		gsout.Append(output);
		output.pos = mul(float4(p2,1.0f), mul(tW,tVP));
		gsout.Append(output);
		output.pos = mul(float4(p3,1.0f), mul(tW,tVP));
		gsout.Append(output);
		
	}
}

[maxvertexcount(4)]
void GS_Slice_Short(triangle vsInput input[3], inout TriangleStream<psInput> gsout)
{
	psInput output;
	
	float3 dists;
	dists.x = sdPlane(input[0].pos.xyz, Plane);
	dists.y = sdPlane(input[1].pos.xyz, Plane);
	dists.z = sdPlane(input[2].pos.xyz, Plane);
	
	float3 sides = dists > 0.0f;
	
	float count = sides.x + sides.y + sides.z;
	
	output.color = 1;
	
	if (count == 0)
		return;
	
	if (count == 3)
	{
		for (int i = 0; i < 3; i++)
		{
			float4 p = input[i].pos;
			output.pos = mul(p, mul(tW,tVP));
			gsout.Append(output);
		}		
	}
	else
	{
		sides = count == 2 ? 1.0f - sides : sides;
		
		uint aboveidx = sides.x > 0 ? 0 : (sides.y > 0 ? 1 : 2);
		uint other1 = (aboveidx + 1) % 3;
		uint other2 = (aboveidx + 2) % 3;
		
		float3 rayPos = input[aboveidx].pos.xyz;
		
		float3 rayDir1 = normalize(input[other1].pos.xyz - rayPos);
		float3 rayDir2 = normalize(input[other2].pos.xyz - rayPos);
		
		float d1,d2;
		rayPlane(rayPos,rayDir1,Plane, d1);
		rayPlane(rayPos,rayDir2,Plane, d2);
		
		float3 p2 = rayPos + rayDir1 * d1;
		float3 p3 = rayPos + rayDir2 * d2;
		
		if (count == 2)
		{
			output.pos = mul(float4(input[other1].pos.xyz,1.0f), mul(tW,tVP));
			gsout.Append(output);
		
			output.pos = mul(float4(input[other2].pos.xyz,1.0f), mul(tW,tVP));
			gsout.Append(output);
		}
		else
		{
			output.pos = mul(float4(rayPos,1.0f), mul(tW,tVP));
			gsout.Append(output);

		}
					
		output.pos = mul(float4(p2,1.0f), mul(tW,tVP));
		gsout.Append(output);
		
		output.pos = mul(float4(p3,1.0f), mul(tW,tVP));
		gsout.Append(output);
	}
}



float4 PS(psInput input): SV_Target
{
    return input.color;
}


technique10 ShowCase
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetGeometryShader(CompileShader(gs_4_0,GS_Case()));
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

technique10 PerformSlicing
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetGeometryShader(CompileShader(gs_4_0,GS_Slice()));
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}


technique10 PerformSlicingShort
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetGeometryShader(CompileShader(gs_4_0,GS_Slice_Short()));
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




