//@author: vux
//@help: draw elements using attributed byte adress buffer
//@tags: color
//@credits: 


struct psInput
{
    float4 posScreen : SV_Position;
    float4 color : COLOR0;
};


ByteAddressBuffer positionBuffer;
ByteAddressBuffer normalBuffer;
ByteAddressBuffer uvBuffer;

cbuffer cbPerDraw : register(b0)
{
	float4x4 tV : LAYERVIEW;
	float4x4 tVP : LAYERVIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float Alpha <float uimin=0.0; float uimax=1.0;> = 1; 
};

psInput VS_Pos(uint iv: SV_VertexID)
{
	psInput output;
	float3 p = asfloat(positionBuffer.Load3(iv*12));
	float4 posObject = float4(p, 1.0f);

	output.posScreen = mul(posObject,mul(tW,tVP));
	output.color = mul(posObject,mul(tW,tV));
	return output;
}

psInput VS_Norm(uint iv: SV_VertexID)
{
	psInput output;
	float3 p = asfloat(positionBuffer.Load3(iv*12));
	float4 posObject = float4(p, 1.0f);

	output.posScreen = mul(posObject,mul(tW,tVP));
	output.color = float4(asfloat(normalBuffer.Load3(iv*12)), 1.0f);
	return output;
}

psInput VS_TexCoord(uint iv: SV_VertexID)
{
	psInput output;
	float3 p = asfloat(positionBuffer.Load3(iv*12));
	float4 posObject = float4(p, 1.0f);

	output.posScreen = mul(posObject,mul(tW,tVP));
	output.color = float4(asfloat(uvBuffer.Load2(iv*8)), 0.0f,1.0f);
	return output;
}

float4 PS(psInput input): SV_Target
{
    return input.color;
}


technique11 Position
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS_Pos() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

technique11 Normal
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS_Norm() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

technique11 TexCoord
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS_TexCoord() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}








