//@author: vux
//@help: template for geometry fx
//@tags: geometry
//@credits:

float4x4 tW : WORLD;
float4x4 tWIT : WORLDINVERSETRANSPOSE;

float MinY;

struct vs2gs
{
	float3 PosO: POSITION;
	float3 Normal: NORMAL;
};

vs2gs VS(
	float3 PosO: POSITION,
	float3 Normal: NORMAL, uint InstanceID: SV_VertexID)
{
	vs2gs Out;
	
	Out.PosO = mul(float4(PosO, 1.0f), tW).xyz;
	Out.Normal = mul(float4(Normal, 0.0f), tWIT).xyz;

    return Out;
}

float openFactor;

void Append(float3 p, float3 n, inout TriangleStream<vs2gs> gsout)
{
	vs2gs output;
	output.PosO = p;
	output.Normal = n;
	gsout.Append(output);
}


[maxvertexcount(8)]
void GS(triangle vs2gs input[3], inout TriangleStream<vs2gs> gsout)
{
	float3 p1 = input[0].PosO.xyz;
	float3 p2 = input[1].PosO.xyz;
	float3 p3 = input[2].PosO.xyz;
	
	float3 n1 = input[0].Normal.xyz;
	float3 n2 = input[1].Normal.xyz;
	float3 n3 = input[2].Normal.xyz;
	
	
	float3 ce = (p1 + p2 + p3) / 3.0f;
	
	float3 pc1 = lerp(ce, p1, openFactor);
	float3 pc2 = lerp(ce, p2, openFactor);
	float3 pc3 = lerp(ce, p3, openFactor);
	
	Append(pc1,n1,gsout);
	Append(p1,n1,gsout);
	
	Append(pc2,n2,gsout);
	Append(p2,n2,gsout);
		
	Append(pc3,n3,gsout);
	Append(p3,n3,gsout);
	
	Append(pc1,n1,gsout);
	Append(p1,n1,gsout);
}


GeometryShader StreamOutGS = ConstructGSWithSO( CompileShader( gs_4_0, GS() ),"0:POSITION.xyz;1:NORMAL.xyz", NULL,NULL,NULL,-1 );
//if the above does not work, try this line instead
//GeometryShader StreamOutGS = ConstructGSWithSO( CompileShader( vs_4_0, VS() ), "POSITION.xyz;NORMAL.xyz;TEXCOORD.xy" );

technique10 PassMesh
{
    pass PP2
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetGeometryShader( StreamOutGS );
    }   
}