#define PI 3.14159265

float3 sphere(float u, float v)
{
	float3 p;
	u = (u + 0.5) * PI * 2.0f * 2.0f;
	v = (v + 0.5) * PI * 2.0f;
	float su = sin(u); float sv = sin(v); float cu = cos(u); float cv = cos(v);
	p.x = su*sv;
	p.y = cu*sv;
	p.z = cv;	
	return p;
}

float2 size;
int rowcount;
int colcount;
float2 invgridsize;

struct vsInput
{
    uint iv : SV_VertexID;
};

struct vsOutput
{
    float3 pos  : POSITION; 
	float3 norm  : NORMAL; 
	float2 uv : TEXCOORD0;
};

struct vsOutputIndices
{
    int3 t1 : TRIANGLE0;
	int3 t2 : TRIANGLE1;
};

vsOutput VS_Vertices(vsInput input)
{
	vsOutput o;
	int colindex = input.iv % colcount;
	int rowindex = input.iv / colcount;	
	float2 uv = float2(input.iv % colcount,input.iv / colcount) * invgridsize;
	float2 pos = uv;
	
	uv.y = 1.0f - uv.y;
	pos.xy = (pos.xy - 0.5f) * size;
	o.pos = float3(pos,0.0f);
	o.norm = float3(0,0,-1);
	o.uv = uv;
    return o;
} 


vsOutputIndices VS_Indices(vsInput input)
{
	vsOutputIndices o;
	int j = input.iv / (colcount-1);
	int i = input.iv % (colcount-1);	
	int rowlow = j * (colcount);
	int rowup = (j+1) * (colcount);
	
	o.t1 = int3(rowlow + i, rowup + i, rowlow + i + 1);
	o.t2 = int3(rowlow + i + 1, rowup + i, rowup + i + 1);
    return o;
} 


GeometryShader SO_Vertices = ConstructGSWithSO( CompileShader( vs_4_0, VS_Vertices() ), "POSITION.xyz;NORMAL.xyz;TEXCOORD.xy",NULL,NULL,NULL,-1 );
GeometryShader SO_Indices = ConstructGSWithSO( CompileShader( vs_4_0, VS_Indices() ), "1:TRIANGLE0.xyz;1:TRIANGLE1.xyz",NULL,NULL,NULL,-1 );

technique10 GenerateVertices
{
    pass P0
    {
        SetVertexShader( CompileShader( vs_4_0, VS_Vertices() ) );
        SetGeometryShader( SO_Vertices );
    }  
}

technique10 GenerateIndices
{
    pass P0
    {
        SetVertexShader( CompileShader( vs_4_0, VS_Indices() ) );
        SetGeometryShader( SO_Indices );
    }  
}