//@author: vux
//@help: uses two streams for outputting geometry, depending on if it's above or below some level
//@tags: geometry
//@credits:

float4x4 tW : WORLD;
float4x4 tWIT : WORLDINVERSETRANSPOSE;

float thresholdY <string uiname="Threshold Y";>;

struct vs2gs
{
	float3 pos: POSITION;
	float3 norm: NORMAL;
};

vs2gs VS(float3 pos: POSITION, float3 norm: NORMAL)
{
	vs2gs output;
	
	output.pos = mul(float4(pos, 1.0f), tW).xyz;
	output.norm = mul(float4(norm, 0.0f), tWIT).xyz;

    return output;
}

[maxvertexcount(8)]
void GS(triangle vs2gs input[3], 
	inout PointStream<vs2gs> gsout1,
	inout PointStream<vs2gs> gsout2)
{
	float3 p1 = input[0].pos.xyz;
	float3 p2 = input[1].pos.xyz;
	float3 p3 = input[2].pos.xyz;
	
	float3 ce = (p1 + p2 + p3) / 3.0f;
	
	if (ce.y < thresholdY)
	{
		[unroll]
		for (int i = 0; i < 3; i++)
		{
			gsout1.Append(input[i]);
		}
	}
	else
	{
		[unroll]
		for (int i = 0; i < 3; i++)
		{
			gsout2.Append(input[i]);
		}		
	}
}


GeometryShader StreamOutGS = ConstructGSWithSO( 
CompileShader( gs_5_0, GS() ),
"0:POSITION.xyz;0:NORMAL.xyz", 
"1:POSITION.xyz;1:NORMAL.xyz",
NULL,NULL,-1 );

technique10 PassMesh
{
    pass PP2
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetGeometryShader( StreamOutGS );
    }   
}