#define PI acos(-1)


struct dsInput
{
	float3 position : POSITION;
    uint iv : VERTEXID;	
};

struct hullConstantOutput
{
    float edges[2] : SV_TessFactor;
}; 


struct gsInput
{
	float3 worldPosition : WORLDPOSITION;
    float3 position : POSITION;
	float innerRadius : INNERRADIUS;
};

struct psInput
{
    float4 posScreen : SV_Position;
};

cbuffer cbPerDraw : register(b0)
{
	float4x4 tVI : VIEWINVERSE;
	float4x4 tVP : LAYERVIEWPROJECTION;
};

cbuffer cbSegmentData : register(b2)
{
	float OuterRadius <string uiname="Outer Radius";> = 1.0f;
	float InnerRadius <string uiname="Inner Radius";> = 1.0f;
	float Phase = 0.0f;
	float Cycles = 1.0f;
	float Resolution = 5;
	float invResolutionMinus1 <string uiname="Inverse Resolution Minus 1";>;
}

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
};

dsInput VS(uint iv : SV_VertexID)
{
	dsInput output;
	output.position = float3(tW._41,tW._42,tW._43);
	output.iv = iv;
	return output;
}

hullConstantOutput HSConstant()
{
    hullConstantOutput output;
    output.edges[0] = 1.0f;
    output.edges[1] = Resolution;
    return output;
}

[domain("isoline")]
[partitioning("integer")]
[outputtopology("line")]
[outputcontrolpoints(1)]
[patchconstantfunc("HSConstant")]
dsInput HS(InputPatch<dsInput, 1> inputPatch, uint id : SV_OutputControlPointID)
{
    return inputPatch;
}

[domain("isoline")]
gsInput DS(hullConstantOutput input, OutputPatch<dsInput, 1> op, float2 uv : SV_DomainLocation)
{
    gsInput output;
	
	uint vid = op[0].iv;
	float u = uv.x;

	float x= cos(u * PI * 2.0f*Cycles+(Phase*PI*2.0f));
	float y= sin(u * PI * 2.0f*Cycles+(Phase*PI*2.0f));
		
	output.position = float3(x,y,0.0f)* OuterRadius;
	output.innerRadius = InnerRadius;
	output.worldPosition = op[0].position;
	return output;
}

[maxvertexcount(4)]
void GS(line gsInput input[2], inout TriangleStream<psInput> gsout)
{
	float3 p1 = input[0].position;
	float3 p2 = input[1].position;

	float3 pi1 = p1*input[0].innerRadius;
	float3 pi2 = p2*input[1].innerRadius;
	
	
	p1 = mul( p1, (float3x3)tVI ) + input[0].worldPosition.xyz;
	p2 = mul( p2, (float3x3)tVI ) + input[1].worldPosition.xyz;
	
	pi1 = mul( pi1, (float3x3)tVI ) + input[0].worldPosition.xyz;
	pi2 = mul( pi2, (float3x3)tVI ) + input[1].worldPosition.xyz;
	
	psInput output;
	output.posScreen = mul(float4(p1,1.0f),tVP);
	gsout.Append(output);
	
	output.posScreen = mul(float4(p2,1.0f),tVP);
	gsout.Append(output);
	
	output.posScreen =  mul(float4(pi1,1.0f),tVP);
	gsout.Append(output);
	
	output.posScreen = mul(float4(pi2,1.0f), tVP);
	gsout.Append(output);
	
	gsout.RestartStrip();
}

float4 PS(psInput input): SV_Target
{
    return cAmb;
}

technique11 Render
{
	pass P0 <string topology="PatchListWith1ControlPoint";>
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetHullShader( CompileShader( hs_5_0, HS() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetGeometryShader( CompileShader( gs_4_0, GS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}





