#define PI acos(-1)

struct psInput
{
    float4 posScreen : SV_Position;
};

cbuffer cbPerDraw : register(b0)
{
	float4x4 tVP : LAYERVIEWPROJECTION;
};

cbuffer cbSegmentData : register(b2)
{
	float OuterRadius <string uiname="Outer Radius";> = 1.0f;
	float InnerRadius <string uiname="Inner Radius";> = 1.0f;
	float Phase = 0.0f;
	float Cycles = 1.0f;
	float invResolutionMinus1 <string uiname="Inverse Resolution Minus 1";>;
}

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
};

psInput VS(uint iv : SV_VertexID)
{
	psInput output;
	
	float2 p;
	
	float u = iv * invResolutionMinus1;
	
	p.x= cos(u * PI * 2.0f*Cycles+(Phase*PI*2.0f));
	p.y= sin(u * PI * 2.0f*Cycles+(Phase*PI*2.0f));
	
	float4 posObject = float4(p*OuterRadius, 0.0f, 1.0f);
	
	output.posScreen = mul(posObject,mul(tW,tVP));
	return output;
}

float4 PS(psInput input): SV_Target
{
    return cAmb;
}

technique11 Render
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}





