#define PI acos(-1)


struct gsInput
{
	float3 worldPosition : WORLDPOSITION;
    float3 position : POSITION;
	float innerRadius : INNERRADIUS;
};

struct psInput
{
    float4 posScreen : SV_Position;
};

cbuffer cbPerDraw : register(b0)
{
	float4x4 tVI : VIEWINVERSE;
	float4x4 tVP : LAYERVIEWPROJECTION;
};

cbuffer cbSegmentData : register(b2)
{
	float OuterRadius <string uiname="Outer Radius";> = 1.0f;
	float InnerRadius <string uiname="Inner Radius";> = 1.0f;
	float Phase = 0.0f;
	float Cycles = 1.0f;
	float invResolutionMinus1 <string uiname="Inverse Resolution Minus 1";>;
}

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
};

gsInput VS(uint iv : SV_VertexID)
{
	gsInput output;
	
	float2 p;
	
	float u = iv * invResolutionMinus1;
	
	p.x= cos(u * PI * 2.0f*Cycles+(Phase*PI*2.0f));
	p.y= sin(u * PI * 2.0f*Cycles+(Phase*PI*2.0f));
	
	output.position = float3(p, 0.0f);
	output.worldPosition = float3(tW._41,tW._42,tW._43);
	output.innerRadius = InnerRadius;
	return output;
}

[maxvertexcount(4)]
void GS(line gsInput input[2], inout TriangleStream<psInput> gsout)
{
	float3 p1 = input[0].position;
	float3 p2 = input[1].position;

	float3 pi1 = p1*input[0].innerRadius;
	float3 pi2 = p2*input[1].innerRadius;
	
	
	p1 = mul( p1, (float3x3)tVI ) + input[0].worldPosition.xyz;
	p2 = mul( p2, (float3x3)tVI ) + input[1].worldPosition.xyz;
	
	pi1 = mul( pi1, (float3x3)tVI ) + input[0].worldPosition.xyz;
	pi2 = mul( pi2, (float3x3)tVI ) + input[1].worldPosition.xyz;
	
	psInput output;
	output.posScreen = mul(float4(p1,1.0f),tVP);
	gsout.Append(output);
	
	output.posScreen = mul(float4(p2,1.0f),tVP);
	gsout.Append(output);
	
	output.posScreen =  mul(float4(pi1,1.0f),tVP);
	gsout.Append(output);
	
	output.posScreen = mul(float4(pi2,1.0f), tVP);
	gsout.Append(output);
	
	gsout.RestartStrip();
}

float4 PS(psInput input): SV_Target
{
    return cAmb;
}

technique11 Render
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetGeometryShader( CompileShader( gs_4_0, GS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}





