#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using System.Runtime.InteropServices;
using SlimDX;
using VVVV.DX11.Nodes;
#endregion usings

namespace VVVV.Nodes
{
	[StructLayout(LayoutKind.Sequential)]
    public struct SegmentData
    {
        public float OuterRadius;
		public float InnerRadius;
		public float Phase;
		public float Cycles;
    	public int Resolution;
    	public Color4 Color;
    }
	
	#region PluginInfo
	[PluginInfo(Name = "DynamicBuffer", Category = "DX11", Version = "SegmentData", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class SegmentDataDX11DynamicBufferNode : DynamicArrayBuffer<SegmentData>
	{
        [Input("Outer Radius", AutoValidate = false, DefaultValue=1)]
        protected ISpread<float> OuterRadius;
		
		[Input("Inner Radius", AutoValidate = false)]
        protected ISpread<float> InnerRadius;

        [Input("Phase", AutoValidate = false,DefaultValue=0)]
        protected ISpread<float> Phase;
		
		[Input("Cycles", AutoValidate = false,DefaultValue=1)]
        protected ISpread<float> Cycles;
		
		[Input("Resolution", AutoValidate = false,DefaultValue=1)]
        protected ISpread<int> Resolution;

        [Input("Color", AutoValidate = false)]
        protected ISpread<Color4> FColor;

        protected override void BuildBuffer(int count, SegmentData[] buffer)
        {
            this.OuterRadius.Sync();
            this.InnerRadius.Sync();
        	this.Phase.Sync();
            this.Cycles.Sync();
            this.Resolution.Sync();
            this.FColor.Sync();

            for (int i = 0; i < count; i++)
            {
                buffer[i].Color = this.FColor[i];
                buffer[i].Cycles = this.Cycles[i];
                buffer[i].InnerRadius = this.InnerRadius[i];
            	buffer[i].OuterRadius = this.OuterRadius[i];
                buffer[i].Phase = this.Phase[i];
                buffer[i].Resolution = this.Resolution[i];
            }
        }
	}
}
