interface iExtruder
{
	float3 Extrude(float3 p,float3 ce, float3 n, float amt);
};

class cNorm : iExtruder
{
	float3 Extrude(float3 p,float3 ce, float3 n, float amt)
	{
		return p + (n * amt * 0.05f);
	}
};

class cCenter : iExtruder
{
	float3 Extrude(float3 p,float3 ce, float3 n, float amt)
	{
		return lerp(p, ce, amt);
	}
};

class cNormCenter : iExtruder
{
	float3 Extrude(float3 p,float3 ce, float3 n, float amt)
	{
		return lerp(p, ce, amt) + (n * amt * factor);
	}
};

cNorm normExt;
cCenter centerExt;
cNormCenter nodeCExt;

iExtruder extruder <string linkclass="normExt,centerExt,nodeCExt";>;
