float4x4 tW: WORLD ;
float4x4 tV: VIEW ; 
float4x4 tWV: WORLDVIEW ;
float4x4 tWVP: WORLDVIEWPROJECTION ;
float4x4 tP: PROJECTION ;
float4x4 tVP: VIEWPROJECTION ;

#include "waves.fxh"
#include "extruders.fxh"
#include "iqNoise.fxh"


float d;
float tfactor = 1;

float3 noiseFreq = 1;
float3 noiseOffset = 0;
float noiseStr = 1;
bool worldWave = true;

float3 lightDir = float3(0,1,0);

Texture2D texture2d <string uiname="Texture";>;

SamplerState g_samLinear : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};


struct VS_IN
{
	float3 cpoint : POSITION;
	float2 uv : TEXCOORD0;
};

struct VS_OUTPUT
{
	float3 cpoint : CPOINT;
	float2 uv : TEXCOORD0;
};

VS_OUTPUT VS(VS_IN input)
{
    return input;
}

struct HS_CONSTANT_OUTPUT
{
    float edges[4] : SV_TessFactor;
    float inside[2] : SV_InsideTessFactor;
};

struct HS_OUTPUT
{
    float3 cpoint : CPOINT;
	float2 uv : TEXCOORD0;
};

HS_CONSTANT_OUTPUT HSConst()
{
    HS_CONSTANT_OUTPUT output;

    output.edges[0] = tfactor;
    output.edges[1] = tfactor;
	output.edges[2] = tfactor;
	output.edges[3] = tfactor;
	output.inside[0] = tfactor;
	output.inside[1] = tfactor;

    return output;
}

[domain("quad")]
[partitioning("integer")]
[outputtopology("triangle_cw")]
[outputcontrolpoints(4)]
[patchconstantfunc("HSConst")]
HS_OUTPUT HS_I(InputPatch<VS_OUTPUT, 4> ip, uint id : SV_OutputControlPointID)
{
    HS_OUTPUT output;
    output.cpoint = ip[id].cpoint;
	output.uv = ip[id].uv;
    return output;
}



struct DS_OUTPUT
{
    float4 position : POSITION;
	float2 uv : TEXCOORD0;
};

float2 basis(float t)
{
	float invt= 1.0f -t;	
	float2 b;
	b.x = invt;
	b.y = t;
	return b;
}

[domain("quad")]
DS_OUTPUT DS(HS_CONSTANT_OUTPUT input, OutputPatch<HS_OUTPUT, 4> op, float2 uv : SV_DomainLocation)
{
    DS_OUTPUT output;
	
	float3 p = float3(uv.x-0.5f,uv.y-0.5f,0.5);
		
	float tx = uv.x;
	float ty = uv.y;
	float invX = 1.0f - uv.x;
	float invY = 1.0f - uv.y;
	
	float2 bu = basis(uv.x);
	float2 bv = basis(uv.y);
	
	float3 po = float3(0,0,0);
    po  = bv.x * ( op[0].cpoint * bu.x + op[1].cpoint * bu.y);
    po += bv.y * ( op[2].cpoint * bu.x + op[3].cpoint * bu.y);
	
	float2 tcd;
    tcd  = bv.x * ( op[0].uv * bu.x + op[1].uv * bu.y);
    tcd += bv.y * ( op[2].uv * bu.x + op[3].uv * bu.y);
	
    output.position = float4(po,1);
	output.uv = tcd;

    return output;
}

struct psInput
{
    float4 position : SV_Position;
	float2 uv: TEXCOORD;
	float3 norm : NORMAL;
};

void Append(inout TriangleStream<psInput> gsout, psInput p)
{
	p.position= mul(p.position, tWVP);
	gsout.Append(p);
}

void AppendPos(inout TriangleStream<psInput> gsout, psInput p, float3 po, float2 uv)
{
	p.uv = uv;
	p.position= mul(float4(po,1.0f), tVP);
	gsout.Append(p);
}

struct ed
{
	float3 e1;
	float3 e2;
};


bool square;
bool wave = false;

[maxvertexcount(3)]
void GS(triangle DS_OUTPUT input[3], inout TriangleStream<psInput> gsout )
{
	psInput output;
	float3 t1 = input[0].position.xyz;
	float3 t2 = input[1].position.xyz;
	float3 t3 = input[2].position.xyz;
	
	float3 ce = 0;
	float e1 = distance(t1,t2);
	float e2 = distance(t2,t3);
	float e3 = distance(t3,t1);
	
	float mx = max(e1,max(e2,e3));
		
	if (e1 == mx) { ce = (t1 + t2) * 0.5f; }
	if (e2 == mx) { ce = (t2 + t3) * 0.5f; }
	if (e3 == mx) { ce = (t3 + t1) * 0.5f; }
	
	float3 cw = worldWave ? mul(float4(ce, 1.0f),tW).xyz : ce;
	
	float3 n = float3(0,0,-1);
	
	output.norm = n;
	
	float ext = extFunc.Calc(cw);

	t1 = extruder.Extrude(t1,ce,n,ext);
	output.position = float4(t1,1);
	output.uv = input[0].uv;

	Append(gsout, output);

	t2 = extruder.Extrude(t2,ce,n,ext);
	output.position = float4(t2,1);
	output.uv = input[1].uv;
	Append(gsout, output);
	
	t3 = extruder.Extrude(t3,ce,n,ext);
	output.position = float4(t3,1);
	output.uv = input[2].uv;
	Append(gsout, output);
	
	gsout.RestartStrip();
}

void MultiTri(inout psInput o,float3 p1,float3 p2,float3 p3, 
float2 uv1,float2 uv2, float2 uv3, float amt, float3 ce, inout TriangleStream<psInput> gsout)
{
	float3 faceEdgeA = p2 - p1;
    float3 faceEdgeB = p1 -p3;
    float3 norm = cross(faceEdgeB, faceEdgeA);	
	norm = normalize(norm);
	
	o.norm = norm;
	AppendPos(gsout, o, p1,uv1);
	AppendPos(gsout, o, p2,uv2);
	AppendPos(gsout, o, p3, uv3);
	gsout.RestartStrip();
	
	float3 p1e = extruder.Extrude(p1,ce,norm,amt);
	float3 p2e = extruder.Extrude(p2,ce,norm,amt);
	float3 p3e = extruder.Extrude(p3,ce,norm,amt);
		
	AppendPos(gsout, o, p1e,uv1);
	AppendPos(gsout, o, p2e,uv2);
	AppendPos(gsout, o, p3e,uv3);
	gsout.RestartStrip();
    
	float3 fa = p3 - p3e;
    float3 fb = p3e -p1;
	float3 pn = cross(fa, fb);
	pn = normalize(pn);
	o.norm = pn;
	
	AppendPos(gsout, o, p3,uv3);
	AppendPos(gsout, o, p1,uv1);
	AppendPos(gsout, o, p3e,uv3);
	AppendPos(gsout, o, p1e,uv1);
		
	 fa = p2 - p2e;
     fb = p2e -p1;
	 pn = cross(fa, fb);
	pn = normalize(pn);
	o.norm = pn;
	
	AppendPos(gsout, o, p1,uv1);
	AppendPos(gsout, o, p2,uv2);
	AppendPos(gsout, o, p1e,uv1);
	AppendPos(gsout, o, p2e,uv2);
	
	
	fa = p2 - p2e;
     fb = p2e -p3;
	 pn = cross(fa, fb);
	pn = normalize(pn);
	o.norm = pn;
	
	AppendPos(gsout, o, p2, uv2);
	AppendPos(gsout, o, p3, uv3);
	AppendPos(gsout, o, p2e ,uv2);
	AppendPos(gsout, o, p3e , uv3);
	
	gsout.RestartStrip();
}

[maxvertexcount(24)]
void GS_Cube(triangle DS_OUTPUT input[3], inout TriangleStream<psInput> gsout )
{
	psInput output;
	output.norm = 0;
	output.uv = 0;
	output.position = 0;
	float3 t1 = input[0].position.xyz;
	float3 t2 = input[1].position.xyz;
	float3 t3 = input[2].position.xyz;
	
	float3 ce = 0;

	float e1 = distance(t1,t2);
	float e2 = distance(t2,t3);
	float e3 = distance(t3,t1);
	
	float mx = max(e1,max(e2,e3));
		
	if (e1 == mx) { ce = (t1 + t2) * 0.5f; }
	if (e2 == mx) { ce = (t2 + t3) * 0.5f; }
	if (e3 == mx) { ce = (t3 + t1) * 0.5f; }
	
	float3 n = float3(0,0,-1);
	
	t1 = mul(float4(t1,1.0f),tW).xyz;
	t2 = mul(float4(t2,1.0f),tW).xyz;
	t3 = mul(float4(t3,1.0f),tW).xyz;
	ce = worldWave ? mul(float4(ce, 1.0f),tW).xyz : ce;
	
	float ext = extFunc.Calc(ce);
	
	MultiTri(output, t1,t2,t3,input[0].uv,input[1].uv,input[2].uv, ext,ce, gsout);
}

float4 PS(psInput input) : SV_Target0
{
	float3 nv = mul(float4(input.norm,0.0f),tWV).xyz;
	nv = normalize(nv);
	
	float l = dot(nv,lightDir);
	//return float4(input.uv,0,1);
    //return float4(input.center*5, 1.0f);
	return texture2d.Sample(g_samLinear, input.uv)*l;
}

technique11 PerSquare
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS_I() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader(CompileShader(gs_5_0, GS()));
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}

technique11 Cube
{
	pass P0
	{
		SetHullShader( CompileShader( hs_5_0, HS_I() ) );
		SetDomainShader( CompileShader( ds_5_0, DS() ) );
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader(CompileShader(gs_5_0, GS_Cube()));
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}