float3 freq = 1;
float3 offset = 0;
float str = 1.0f;
float factor;

interface iExtFunc
{
	float Calc(float3 ce);
};

class cSinX : iExtFunc
{
	float Calc(float3 ce)
	{
		float s = sin(ce.x*freq.x + offset.x);
		return abs(s)*str;
	}
};


class cSquareSinX : iExtFunc
{
	float Calc(float3 ce)
	{
		float s = sin(ce.x*freq.x + offset.x) > 0;
		return abs(s)*str;
	}
};


class cSinY  : iExtFunc
{
	float Calc(float3 ce)
	{
		return abs(sin(ce.y*freq.y + offset.y))*str;
	}
};

class cSquareSinY : iExtFunc
{
	float Calc(float3 ce)
	{
		float s = sin(ce.y*freq.y + offset.y) > 0;
		return abs(s)*str;
	}
};



class cAbsSinX : iExtFunc
{
	float Calc(float3 ce)
	{
		return abs(sin(abs(ce.x)*freq.x + offset.x))*str;
	}
};

class cAbsSinY  : iExtFunc
{
	float Calc(float3 ce)
	{
		return abs(sin(abs(ce.y)*freq.y + offset.y))*str;
	}
};

class cRadial : iExtFunc
{
	float Calc(float3 ce)
	{
		return abs(sin(abs(dot(ce.xy,ce.xy))*freq.x + offset.x))*str;
	}
};

class cSquareRadial : iExtFunc
{
	float Calc(float3 ce)
	{
		return abs(sin(abs(dot(ce.xy,ce.xy))*freq.x + offset.x) > 0)*str;
	}
};


cSinX sinX;
cSinY sinY;
cSquareSinY squareSinY;
cAbsSinX absSinX;
cSquareSinX squareSinX;
cAbsSinY absSinY;
cRadial radial;
cSquareRadial squareRadial;

iExtFunc extFunc <string linkclass = "sinX,squareSinX,sinY,squareSinY,absSinX,absSinY,radial,squareRadial";>;
