//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = NONE;         //sampler states
    MinFilter = POINT;
    MagFilter = POINT;

};
 
//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float2 TexCd : TEXCOORD0;
};
 
float2 PixelSize;
float4 PS(vs2ps In): COLOR
{
	//sample the current pixel
	float4 center = tex2D(Samp, In.TexCd);
	
	//prepare pixel offsets for x and y
	float2 offX = float2 (PixelSize.x, 0);
	float2 offY = float2 (0, PixelSize.y);
		
	//sample neighbours and add up their states
	float alive = 0;
	alive += tex2D(Samp, In.TexCd - offY).r;
	alive += tex2D(Samp, In.TexCd - offY - offX).r;
	alive += tex2D(Samp, In.TexCd - offY + offX).r;
	alive += tex2D(Samp, In.TexCd + offY).r;
	alive += tex2D(Samp, In.TexCd + offY - offX).r;
	alive += tex2D(Samp, In.TexCd + offY + offX).r;
	alive += tex2D(Samp, In.TexCd - offX).r;
	alive += tex2D(Samp, In.TexCd + offX).r;

	//a dead cell with exactly three live neighbors becomes a live cell (birth).
	if (center.r == 0 && alive == 3) 
	{
	  center.rgb = 1;
	} 
	//a live cell with two or three live neighbors stays alive (survival).  
	else if (center.r == 1 && (alive == 3 || alive == 2)) 
	{
	  center.rgb = 1;
	} 
	//in all other cases, a cell dies or remains dead (overcrowding or loneliness).
	else 
	{
	  center.rgb = 0;
	}

	return center;
}
 
technique TSimpleShader
{
    pass P0
    {
        VertexShader = null;
        PixelShader  = compile ps_2_0 PS();
    }
}