//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float2 TexCd : TEXCOORD0;
};
 
float4 ConvertToGray(float4 col)
{
    const float3 lumCoeff = {0.3, 0.59, 0.11};
    col.rgb = dot(col.rgb, lumCoeff);
    return col;
} 
 
float2 PixelSize;
float Threshold = 0.2;
//horizontal edge detection
float4 PS(vs2ps In): COLOR
{
    //the texture coordinate offset with vertical coordinate set to 0
    float2 off = float2(PixelSize.x, 0);
	
    //sample the left and the right neighbouring pixels
    float4 left = tex2D(Samp, In.TexCd - off);
    float4 right = tex2D(Samp, In.TexCd + off);
	
    if (abs(ConvertToGray(left).x - ConvertToGray(right).x) > Threshold)
      return 1;
    else
      return float4(0, 0, 0, 1);
}

//horizontal and vertical detection for improved result
//float4 PS(vs2ps In): COLOR
//{
//    //the texture coordinate offset with vertical coordinate set to 0
//    float2 off = float2(PixelSize.x, 0);
//	
//    //sample the left and the right neighbouring pixels
//    float4 left = tex2D(Samp, In.TexCd - off);
//    float4 right = tex2D(Samp, In.TexCd + off);
//    
//    //the texture coordinate offset with horizonal coordinate set to 0
//	off = float2(0, PixelSize.y);
//	//sample the upper and the lower neighbouring pixels
//	float4 upper = tex2D(Samp, In.TexCd - off);
//	float4 lower = tex2D(Samp, In.TexCd + off);
//	
//    if (abs(ConvertToGray(left).x - ConvertToGray(right).x) > Threshold
//    ||
//	abs(ConvertToGray(upper) - ConvertToGray(lower)).x > Threshold)
//      return 1;
//    else
//      return float4(0, 0, 0, 1);
//}
 
float4 PSHorizontalBlur(vs2ps In): COLOR
{
    float4 sum = 0;
    int weightSum = 0;
    //the weights of the neighbouring pixels
    int weights[15] = {1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1};
    //we are taking 15 samples
    for (int i = 0; i < 15; i++)
    {
        //7 to the left, self and 7 to the right
        float2 cord = float2(In.TexCd.x + PixelSize.x * (i-7), In.TexCd.y);
        //the samples are weighed according to their relation to the current pixel
        sum += tex2D(Samp, cord) * weights[i];
        //while going through the loop we are summing up the weights
        weightSum += weights[i];
    }
    sum /= weightSum;
    return float4(sum.rgb, 1);
} 

float4 PSVerticalBlur(vs2ps In): COLOR
{
    float4 sum = 0;
    int weightSum = 0;
    //the weights of the neighbouring pixels
    int weights[15] = {1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1};
    //we are taking 15 samples
    for (int i = 0; i < 15; i++)
    {
        //7 upwards, self and 7 downwards
        float2 cord = float2(In.TexCd.x, In.TexCd.y + PixelSize.y * (i-7));
        //the samples are weighed according to their relation to the current pixel
        sum += tex2D(Samp, cord) * weights[i];
        //while going through the loop we are summing up the weights
        weightSum += weights[i];
    }
    sum /= weightSum;
    return float4(sum.rgb, 1);
} 
 
technique TEdgeDetect
{
    pass P0
    {
        VertexShader = null;
        PixelShader  = compile ps_2_0 PS();
    }
}

technique THorizontalBlur
{
    pass P0
    {
        VertexShader = null;
        PixelShader  = compile ps_2_0 PSHorizontalBlur();
    }
}

technique TVerticalBlur
{
    pass P0
    {
        VertexShader = null;
        PixelShader  = compile ps_2_0 PSVerticalBlur();
    }
}