//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
};

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float2 TexCd : TEXCOORD0;
};
 
//for texture ripple and function plotting
float Frequency = 10; //50
float Phase = 0;
float Amplitude = 0.1;	//1
float4 PS(vs2ps In): COLOR
{
	//visualizing texture coordinates
    return float4(In.TexCd, 0, 1);

	//shifting the x coordinate
//	float2 cord = In.TexCd;
//	cord.x += 0.5;
//	return tex2D(Samp, cord);
	
	//texture ripple
//    float2 cord = In.TexCd;
//    cord.x += sin(cord.y * Frequency + Phase) * Amplitude;
//    float4 col = tex2D(Samp, cord);
//    return col;
	
	//function printing
//	float2 cord = In.TexCd - 0.5;
//    float dist = sqrt(pow(cord.x, 2) + pow(cord.y, 2));
//    float4 col = sin(dist * Frequency + Phase) * Amplitude;
//    col.a = 1;  //make sure the alpha component is 1
//    return col;
}
 
technique TSimpleShader
{
    pass P0
    {
        VertexShader = null;
        PixelShader  = compile ps_2_0 PS();
    }
}