//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float2 TexCd : TEXCOORD0;
};

float4 ConvertToGray(float4 col)
{
    const float3 lumCoeff = {0.3, 0.59, 0.11};
    col.rgb = dot(col.rgb, lumCoeff);
    return col;
}

//for contrast example
float Contrast = 1;

float4 PS(vs2ps In): COLOR
{
	//returning red 
	return float4(1, 0, 0, 1);
	
	//returning a darker red
//	float4 col;
//	col = float4(1, 0, 0, 1);
//	col /= 2;     //short syntax for: col = col / 2
//	return col;

	//returns an orange
//	float4 col = float4(1, 0, 0, 1);
//	col.g = col.r / 2;
//	return col;

	//returns the image as is
//	return tex2D(Samp, In.TexCd);

	//returns the images red and blue channels switched
//	float4 col = tex2D(Samp, In.TexCd);
//	return col.bgra;
	
	//returns the value of the blue channel for all other channels as well
//	float4 col = tex2D(Samp, In.TexCd);
//	return col.b;  //short syntax for: return float4(col.b, col.b, col.b, col.b)

	//inverts the image
//	float4 col = tex2D(Samp, In.TexCd);
//	col.rgb = 1 - col.rgb;
//	return col;

	//contrasts the image
//	float4 col = tex2D(Samp, In.TexCd);
//	col.rgb -= 0.5;
//	col.rgb *= Contrast;
//	col.rgb += 0.5;
//	return col;

	//image to grayscale I
//	float4 col = tex2D(Samp, In.TexCd);
//	col.rgb = col.r * 0.3 + col.g * 0.59 + col.b * 0.11;
//	return col;

	//image to grayscale II
//	float4 col = tex2D(Samp, In.TexCd);
//	const float3 lumCoeff = {0.3, 0.59, 0.11};
//	col.rgb = dot(col.rgb, lumCoeff);
//	return col;

	//using a custom ConvertToGray function
//	float4 col = tex2D(Samp, In.TexCd);
//	return ConvertToGray(col);
}
 
technique TSimpleShader
{
    pass P0
    {
        VertexShader = null;
        PixelShader  = compile ps_2_0 PS();
    }
}