//texture
texture TexA <string uiname="Texture A";>;
sampler SampA = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexA);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

texture TexB <string uiname="Texture B";>;
sampler SampB = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexB);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

texture TexMask <string uiname="Mask";>;
sampler SampMask = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexMask);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
 
texture TexOff <string uiname="Offset Texture";>;
sampler SampOff = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexOff);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR; //POINT
};

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float2 TexCd : TEXCOORD0;
};
 
float Fade = 0.5;
float4 PS(vs2ps In): COLOR
{
	//fade between two textures
	float4 colA = tex2D(SampA, In.TexCd);
	float4 colB = tex2D(SampB, In.TexCd);
	
	return lerp(colA, colB, Fade);
	
	//blend two textures using a mask
//	float4 colA = tex2D(SampA, In.TexCd);
//	float4 colB = tex2D(SampB, In.TexCd);
//	float4 mask = tex2D(SampMask, In.TexCd);
//	
//	return lerp(colA, colB, mask.r);

	//texture glitch effect
//	float4 offset = tex2D(SampOff, In.TexCd) - 0.5;
//	float4 col = tex2D(SampA, float2(In.TexCd.x + offset.r, In.TexCd.y));
//	return col;
}
 
technique TSimpleShader
{
    pass P0
    {
        VertexShader = null;
        PixelShader  = compile ps_2_0 PS();
    }
}