//@author: colorsound
//@credits: Thnaks dottore for particle workshop

//Attractors Position Buffer
StructuredBuffer<float3> AttractorCenter;
//Attractors Parameters Buffer
StructuredBuffer<float3> RadiusPowerStrength;
//Extra random from SphereRandom spread 
StructuredBuffer<float3> SphereRandom;

bool ApplySphereSpread = false;

float Attack=0.8;
float Decay=0.99;

#include "Attractor3d.fxh"
#include "Map.fxh"

struct OutputBuffer
{
	float3 Pos ;
	float3 prevPos;
	float3 Norm ;
	float3 TexCd ;
	float3 dirValuePos;
	float3 processValuePos;
	float3 diffValuePos;
	//uint3 Indices;
};
// buffers from the model 
StructuredBuffer<float3> PositionBuffer;
StructuredBuffer<float3> NormalsBuffer;
StructuredBuffer<float3> UvBuffer;
//ByteAddressBuffer IndicesBuffer;

RWStructuredBuffer<OutputBuffer> Output : BACKBUFFER;

[numthreads(64, 1, 1)]
void GeomtryStructured_CS( uint3 i : SV_DispatchThreadID)
{ 
	//uint i1 = IndicesBuffer.Load(index * 12);
	//uint i2 = IndicesBuffer.Load(index * 12+4);
	//uint i3 = IndicesBuffer.Load(index * 12+8);
	//uint3 indices = uint3(i1,i2,i3);

	    uint index=i.x;	//threads Index
	
	    float3 Pos = PositionBuffer[index]+SphereRandom[index];//This is Pos from the model 
	    float3 Norm = NormalsBuffer[index];//Normals from teh model 
	    float3 TexCd = UvBuffer[index];//Texture coordinates from the model
	

	
	    Output[i.x].Norm=Norm;//Send Normals out in the buffer 
        Output[i.x].TexCd=TexCd;//Send Texture coordinates out in the buffer 
	
	    //Input the value from Current to the Previous slot
        Output[i.x].prevPos = Output[i.x].Pos;	
	
	    //Get the amount of attractors 
		uint count,dummy;	
		AttractorCenter.GetDimensions(count,dummy);
   
 	    if(ApplySphereSpread==true) 	
	    Output[i.x].Pos =Pos+SphereRandom[index];
	    else
        Output[i.x].Pos=PositionBuffer[index];
	
     for(uint a=0 ; a < count; a++)
		{
////////
//Insert desired values 
	
   float3 attrtest = attractor3d(Output[i.x].Pos.xyz,AttractorCenter[a],RadiusPowerStrength[a].x,RadiusPowerStrength[a].y,RadiusPowerStrength[a].z);

   Output[i.x].Pos = attrtest ;	

        }
	

	
////FRAMEDIFF PROCEDURE
 //Get the difference
 Output[i.x].diffValuePos = Output[i.x].Pos-Output[i.x].prevPos;
 //Get direction of value and map to 0-1
 Output[i.x].dirValuePos = MapClamp3(sign(Output[i.x].diffValuePos),-1,1,0,1);	
 float3 dirValuePos = Output[i.x].dirValuePos;

 //If the value goes up do a IIR filter with Attack
 if (dirValuePos.xyz==1,1,1) 
 Output[i.x].Pos =lerp(Output[i.x].Pos,Output[i.x].prevPos,Attack);
 //If the value goes down do a IIR filter with Decay
	
//Btw Attack does not work with atractor ? 
 if(dirValuePos==0,0,0)
 Output[i.x].Pos =lerp(Output[i.x].Pos,Output[i.x].prevPos,Decay);

//Output result Value to other shader, This is the affecting value to display the particles.
Output[i.x].processValuePos = Output[i.x].Pos;


}

technique11 TGeomtryStructured
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, GeomtryStructured_CS() ) );
	}
}





