//@author: colorsound
//@credits: Thnaks dottore for particle workshop

float4x4 tV : VIEW;
float4x4 tVP : VIEWPROJECTION;
float4x4 tVI : VIEWINVERSE;

float Gamma = 1;
float Thr =1;


bool  OnlyVelocity = false;

#include "PhongPoint.fxh"
//Gamma Function 
#define Gamma(x,y) (sign(x)*pow(abs(x),y))

float Alpha <float uimin=0.0; float uimax=1.0;> = 1;
Texture2D texture2d;
Texture2D textureMask;
float4 c <bool color=true;> = 1;

struct particle
{
	float3 pos;
	float3 vel;
};


struct OutputBuffer
{
	float3 Pos ;
	float3 prevPos;
	float3 Norm ;
	float3 TexCd ;
	float3 dirValuePos;
	float3 processValuePos;
	float3 diffValuePos;
	//uint3 Indices;

};

StructuredBuffer<OutputBuffer> pData;

    float radius = 0.05f;
 
    float3 g_positions[4]:IMMUTABLE =
    {
        float3( -1, 1, 0 ),
        float3( 1, 1, 0 ),
        float3( -1, -1, 0 ),
        float3( 1, -1, 0 ),
    };
    float2 g_texcoords[4]:IMMUTABLE = 
    { 
        float2(0,1), 
        float2(1,1),
        float2(0,0),
        float2(1,0),
    };



SamplerState g_samLinear : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

struct VS_IN
{
	uint iv : SV_VertexID;
	//float4 p: POSITION;	
};

struct vs2ps
{
    float4 PosWVP: SV_POSITION ;	
	float2 TexCd : TEXCOORD0 ;
	float2 TexCdM : TEXCOORD1 ;
	float4 Vcol : COLOR ;


    float3 LightDirV: TEXCOORD2;
    float3 NormV: TEXCOORD3;
    float3 ViewDirV: TEXCOORD4;
    float3 PosW: TEXCOORD5;
	
	
	
};

vs2ps VS(VS_IN input)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
	
	float3 Position = pData[input.iv].processValuePos;
	//float3 v = pData[input.iv].vel;
	
    Out.PosWVP = float4(Position,1);// mul(float4(po.xyz,1),tVP);
	//Out.Vcol = float4(saturate(v * velColMult)+0.5,1);
	Out.Vcol = float4(saturate(abs(Gamma(pData[input.iv].diffValuePos,Gamma))),1) ; 
	float3 tc =  pData[input.iv].TexCd;
	Out.TexCd= tc;
	
	
	//normal in view space
	float3 Normals = pData[input.iv].Norm;
	Out.NormV = Normals;
	
	
	Out.PosW = Position;
	//inverse light direction in view space
    //float3 LightDirW = normalize(lPos - Out.PosW);
	Out.LightDirV = Out.LightDirV;
	Out.ViewDirV = Out.ViewDirV;
	
	
	
    return Out;
}

[maxvertexcount(4)]
void GS(point vs2ps input[1], inout TriangleStream<vs2ps> SpriteStream)
{
    vs2ps output;
    
    
    // Emit two new triangles
    //
    for(int i=0; i<4; i++)
    {
        float3 position = g_positions[i]*radius;
    	 float3 positionO = g_positions[i]*radius;
        position = mul( position, (float3x3)tVI ) + input[0].PosWVP.xyz;
    	
    	
    	//float3 norm = mul(float3(0,0,-1),(float3x3)tVI );
        output.PosWVP = mul( float4(position,1.0), tVP );
        
        output.TexCdM = g_texcoords[i];	
    	
    	output.TexCd = input[0].TexCd ;
    	
    	
    	
    	
    	float3 LightDirW = normalize(lPos - position);
        output.LightDirV = mul(float4(LightDirW,0.0f), tV).xyz;
    	
    	
    	output.NormV =normalize(mul(float4(input[0].NormV,0.0f), tVI).xyz);
    	
    	output.ViewDirV = -normalize(mul(positionO, (float3x3)tVI).xyz);
    	
    	output.PosW = position;
    	
    	
        output.Vcol = input[0].Vcol;
    	
        SpriteStream.Append(output);
    }
    SpriteStream.RestartStrip();
}

float4 MeshParticle_PS(vs2ps In): SV_Target
{
    float4 col = texture2d.Sample( g_samLinear, In.TexCd)*c;
	
	float4 Diffcol = In.Vcol;
	

	
	col.rgb *= PhongPoint(In.PosW, In.NormV, In.ViewDirV, In.LightDirV).rgb;
	if (Diffcol.r>0.2)
	col.rb += Diffcol.rgb;

	float4 Mask = textureMask.SampleLevel(g_samLinear,In.TexCdM,0);		
	if (Mask.a == 0) {discard;}
	
	
	//float r = pow(abs(1.5-dot(In.PosW,In.PosW)),1.1);
	//if (r < 0.5f) { discard; }
    //col.rgb * r;
	
	//col*= Mask;
	
	//if(OnlyVelocity==true)
	
	if(In.PosW.z > Thr)
	col.a= Diffcol-0.1;
	
	col.a*=Alpha;
	
	if (col.a < 0.009) {discard;}
	
    return col;
}


technique10 MeshParticle
{
	pass P0
	{
		
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( CompileShader( gs_5_0, GS() ) );
		SetPixelShader( CompileShader( ps_5_0, MeshParticle_PS() ) );
	}
}



