

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tP: PROJECTION;


float3 LampPos <string uiname="Light Direction";> = {0, -5, 2}; 
float Alpha <float uimin=0.0; float uimax=1;> = 1;	
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;

Texture2D Texture2d <string uiname="Texture2d"; >; 

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

bool VERTEX_SHADED=true;

struct vs2ps
{
    float4 HPosition : SV_POSITION;
    float2 TexCoord0 : TEXCOORD0;
    float3 WorldNormal : TEXCOORD1;
    float3 WorldView : TEXCOORD2;
    float3 LightVec : TEXCOORD3;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
 
};



vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

	float3 Nn = normalize(mul(In.Normal,tW).xyz);
    float4 Po = float4(In.Position.xyz,1.0);
    float3 Pw = mul(Po,tW).xyz;
    float3 Vn = normalize(tVI[3].xyz - Pw);
    float3 Ln = normalize(LampPos.xyz - Pw);
    Out.WorldNormal = Nn;
    Out.WorldView = Vn;
    Out.LightVec = Ln;
    float3 Hn = normalize(Vn + Ln);
    Out.TexCoord0 = float2(dot(Ln, Nn), dot(Hn, Nn));
	Out.HPosition = mul(Po,tWVP);
	

    return Out;
}

float4 PS(vs2ps In): SV_Target
{
	

if  (VERTEX_SHADED==false)
	{
	float4 col = Texture2d.Sample(g_samLinear,In.TexCoord0);	
	col.a*=Alpha;
    return col;		
	}
else /* ! VERTEX_SHADED */
	{
    float3 Nn = normalize(In.WorldNormal);
    float3 Vn = normalize(In.WorldView);
    float3 Ln = normalize(In.LightVec);
    float3 Hn = normalize(Vn + Ln);
    float2 uv = float2(dot(Ln, Nn), dot(Hn, Nn));
	float4 col = Texture2d.Sample(g_samLinear,uv);	
	col.a*=Alpha;
    return col;
	}
      
}

technique11 AnisotropicHilight
{
	pass P0
	{
	
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}

