

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tVT:VIEWTRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tWVI: WORLDVIEWINVERSE;
float4x4 tP: PROJECTION;



float Kd <float uimin=0.0; float uimax=1;> = 0.9;

float Ks <float uimin=0.0; float uimax=1;> = 0.5;

float SpecExpon <float uimin=1.0; float uimax=128;> = 1.0;
float DFlatness <float uimin=0.0; float uimax=30.0;> = 1.75;

float SFlatness  <float uimin=0.0; float uimax=50.0;> = 2.25;


float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,1.0};
float4 SurfaceColor  <bool color=true;String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
float4 SpecColor  <bool color=true;String uiname="Specular";>  = {0.7, 0.7, 1,1};
float3 LightDir <string uiname="Light Direction";> = {0.7f,-0.7f,-0.7f};

float Alpha <float uimin=0.0; float uimax=1;> = 1;	
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;



Texture2D texture2d <string uiname="Texture"; >; 

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

bool FLIP_TEXTURE_Y;
bool OBJECT_SPACE_LIGHTS;

struct vs2ps
{
    float4 HPosition	: SV_POSITION;
    float2 UV		: TEXCOORD0;
    float3 WNormalS	: TEXCOORD1;
    float3 WView	: TEXCOORD2;
    float4 DiffCol 	: COLOR0;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
    //float4 Tangent	: TANGENT0;
    //float4 Binormal	: BINORMAL0;
};

vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

	float3 Ne = normalize(mul(In.Normal,tW).xyz); // view coords
    float4 Ned = normalize(float4(Ne.xy,Ne.z*DFlatness,0));
    float4 Nes = normalize(float4(Ne.xy,Ne.z*SFlatness,0));
    float3 Nnd = normalize(mul(Ned,tV).xyz); // world coords
    float3 Nns = normalize(mul(Nes,tV).xyz); // world coords
    float4 Po = float4(In.Position.xyz,1);	// obj coords
    Out.WView = normalize(tVI[3].xyz - Po.xyz);	// obj coords
    Out.WNormalS = Nns; 	// screen clipspace coords
    float3 Ln = -normalize(LightDir);
    float d = dot(Ln,Nnd);
    Out.DiffCol = float4(max(0,d).xxx,1.0);
    float4 Ph = mul(Po,tWVP);
    Out.HPosition = Ph;
	

if(FLIP_TEXTURE_Y==true) 
	{ 
      Out.UV = In.UV.x,(1.0-In.UV.y);
	}
else //* !FLIP_TEXTURE_Y */
	{
    Out.UV = In.UV.xy;
	}

    return Out;
}


float4 Grisaille_PS(vs2ps In): SV_Target
{

	float3 Nns = normalize(In.WNormalS);
    float3 Vn = normalize(In.WView);
    float3 Ln = -LightDir;
    float3 Hn = normalize(Vn + Ln);
    float hdn = Ks * pow(dot(Hn,Nns),SpecExpon);
    float ldn = max(dot(Ln,Nns),0);
    float3 sc = hdn.xxx;
    float4 tc = texture2d.Sample(g_samLinear,In.UV);
    float3 dc = tc.rgb * SurfaceColor * (ldn.xxx + AmbiColor);
    return float4((dc+sc).rgb,Alpha);
	
    
}

technique10 TGrisaille
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, Grisaille_PS() ) );
	}
}

