

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tVT:VIEWTRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tWVI: WORLDVIEWINVERSE;
float4x4 tP: PROJECTION;

//#define SPEC_EXPON 64.0
//#define TOX_TABLE_SIZE 256
//#define TOX_FORMAT "g16r16"


//float spec_func(float s, float NaH, float NaNa) {
//    float toksvig = sqrt(NaNa)/(sqrt(NaNa)+s*(1-sqrt(NaNa)));
//    return (1.0+toksvig*s)/(1.0+s)*pow(NaH/sqrt(NaNa), toksvig*s);
//}

//float4 make_specular_tex(float2 Pos :  SV_POSITION, float2 Size : PSIZE) : SV_Target {
//	float f  = spec_func(SPEC_EXPON,Pos.x,Pos.y);
//	return float4(f.xxx,0.0);
//}


float  SPEC_EXPON = 64.0;


float Kd <float uimin=0.0; float uimax=1;> = 0.9;

float Ks <float uimin=0.0; float uimax=1;> = 0.5;

float Bumpy  = 1.0;
float VRep <float uimin=1.0; float uimax=40.0;> = 1.0;
float URep <float uimin=1.0; float uimax=40.0;> = 1.0;

float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,1.0};
float4 SurfaceColor  <bool color=true;String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
float4 LampColor  <bool color=true;String uiname="Specular";>  = {0.7, 0.7, 1,1};

float3 LightDir <string uiname="LightDirection";> = {0.7f,-0.7f,-0.7f};

float Alpha <float uimin=0.0; float uimax=1;> = 1;	
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;



Texture2D texture2d <string uiname="Texture"; >; 
Texture2D NormalTexture <string uiname="NormalTexture"; >;
Texture2D  SpecTex   <string uiname="Toksvig-Factor Texture"; >;

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState g_samLinearC
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};


struct vs2ps
{
    float4 HPosition : SV_POSITION;
    float2 UV		: TEXCOORD0;
    float3 WorldNormal	: TEXCOORD1;
    float3 WorldView	: TEXCOORD2;
    float3 WorldTangent	: TEXCOORD3;
    float3 WorldBinorm	: TEXCOORD4;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
    float4 Tangent	: TANGENT0;
    float4 Binormal	: BINORMAL0;
};



vs2ps VS(VS_IN In)

{
    vs2ps Out = (vs2ps)0;

    Out.WorldNormal = normalize(mul(In.Normal,tW).xyz);
    Out.WorldTangent = normalize(mul(In.Tangent,tW).xyz);
    Out.WorldBinorm = normalize(mul(In.Binormal,tW).xyz);
    float4 Po = float4(In.Position.xyz,1.0);	// object coordinates
    float3 Pw = mul(Po,tW).xyz;		// world coordinates

    Out.UV = (float2(URep,VRep) * In.UV.xy);

    Out.WorldView = normalize(tVI[3].xyz - Pw);	// obj coords
    Out.HPosition = mul(Po,tWVP);	// screen clipspace coords
   

    return Out;
}


float4 Toksvig_NormalMaps_PS(vs2ps In): SV_Target
{

    float3 Nn = /*normalize*/(In.WorldNormal);
    float3 Tn = /*normalize*/(In.WorldTangent);
    float3 Bn = /*normalize*/(In.WorldBinorm);
	//Bumpy
    float3 bumps = (2*Bumpy) * (NormalTexture.Sample(g_samLinear,In.UV).xyz-(0.5).xxx);
    float3 Na = bumps.x * Tn + bumps.y * Bn + (bumps.z * Nn*Bumpy);
    float3 Vn = normalize(In.WorldView);
    float3 Ln = /*normalize*/(-LightDir);	// normalize() required? FXComposer should provide pre-norm'd value
    float3 Hn = normalize(Vn + Ln);
    float NaH = dot(Hn,Na);
	float NaNa = dot(Na,Na);
	//float2 texelAdjust = (0.5/TOX_TABLE_SIZE).xx;
	//float s = tex2D(SpecSampler,float2(NaH,NaNa)+texelAdjust).x;
	float s = SpecTex.Sample(g_samLinearC,float2(NaH,NaNa)).x;
    Nn = normalize(Na);
    float ldn = dot(Ln,Nn);
	ldn = max(ldn,0);
    float3 diffContrib = ldn * LampColor.xyz;
    float3 specContrib = ((s * Ks) * LampColor.xyz);
    // add, incorporating ambient light term

   float3 colorTex = SurfaceColor * texture2d.Sample(g_samLinear,In.UV).xyz;

   float3 result = colorTex	*(Kd*diffContrib+AmbiColor) + specContrib;
   return float4(result.xyz,Alpha);
    
}


float4 nonToksvigPS(vs2ps In): SV_Target
{
    float3 Nn = normalize(In.WorldNormal);
    float3 Tn = normalize(In.WorldTangent);
    float3 Bn = normalize(In.WorldBinorm);
	

	
    float3 bumps = (Bumpy*2.0) * (NormalTexture.Sample(g_samLinear,In.UV).xyz-(0.5).xxx);
    Nn = (bumps.x*Tn + bumps.y*Bn  + (bumps.z*Nn*Bumpy));
    Nn = normalize(Nn);
    float3 Vn = normalize(In.WorldView);
    float3 Ln = normalize(-LightDir);	// normalize() required?
    float3 Hn = normalize(Vn + Ln);
    float hdn = dot(Hn,Nn);
    float ldn = dot(Ln,Nn);
    float4 litVec = lit(ldn,hdn,SPEC_EXPON);
    float3 diffContrib = litVec.y * LampColor;
    float3 specContrib = ((litVec.z * Ks) * LampColor);
    // add, incorporating ambient light term

    float3 colorTex = SurfaceColor * texture2d.Sample(g_samLinear,In.UV).xyz;

	
   float3 result = colorTex	*(Kd*diffContrib+AmbiColor) + specContrib;
		  return float4(result.xyz,Alpha);
}


technique10 TToksvig_NormalMaps
{
	pass P0
	{

		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, Toksvig_NormalMaps_PS() ) );
	}
}


technique10 TnonToksvigPS
{
	pass P0
	{

		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, nonToksvigPS() ) );
	}
}


