TextureCube texENVI <string uiname="Cubemap Texture";>;
SamplerState s0 <bool visible=false;string uiname="Sampler";> {Filter=MIN_MAG_MIP_LINEAR;AddressU=WRAP;AddressV=WRAP;};

struct VS_IN
{
    float4 PosO : POSITION;
	float3 NorO : NORMAL0;
};
struct VS_OUT
{
    float4 PosWVP : SV_Position;
	float3 NorW : NORMAL0;
	float3 View : NORMAL1;
};
float4x4 tW : WORLD;
float4x4 tVP : VIEWPROJECTION;
float4x4 tVI : VIEWINVERSE;
float4x4 tWIT: WORLDINVERSETRANSPOSE;

float4 Color <bool color=true;> =1;
float4x4 tTex <string uiname="Texture Transform";>;

VS_OUT VS(VS_IN In)
{
	VS_OUT Out = (VS_OUT)0;
	
	//transform position and normals
	float4 PosW=mul(In.PosO,tW);
	Out.PosWVP = mul(PosW,tVP);
	Out.NorW=normalize(mul(float4(normalize(In.NorO.xyz),0),tWIT).xyz);

	//camera position and view vector
	float3 eyePos=mul(float4(0,0,0,1),tVI).xyz;
	Out.View=(PosW.xyz-eyePos);
    return Out;
}

float4 PS_Reflect(VS_OUT In) : SV_Target
{   
	//calculate reflection vector
	float3 uvw=normalize(reflect(normalize(In.View.xyz),normalize(In.NorW.xyz)));
	uvw=mul(float4(uvw.xyz,0),tTex).xyz;
	float4 c=Color*texENVI.Sample(s0,uvw);
	return c;
}

float4 PS_Diffuse(VS_OUT In) : SV_Target
{   
	float3 uvw=mul(float4(In.NorW.xyz,0),tTex).xyz;
	float4 c=Color*texENVI.Sample(s0,uvw);
	return c;
}

float4 PS_SkyBox(VS_OUT In) : SV_Target
{   
	float3 uvw=mul(float4(In.View.xyz,0),tTex).xyz;
	float4 c=Color*texENVI.Sample(s0,uvw);
	return c;
}

technique10 TReflect
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS_Reflect() ) );
    }  
}

technique10 TDiffuse
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS_Diffuse() ) );
    }  
}

technique10 TSkyBox
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS_SkyBox() ) );
    }  
}
