

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tP: PROJECTION;



float Ks <float uimin=0.0; float uimax=1;> = 0.4;
float Kr <float uimin=0.0; float uimax=1;> = 0.5;
float Eccentricity <float uimin=0.0; float uimax=1;> = 0.3;
float Bump1 <float uimin=0.0; float uimax=10;> = 1.0;



float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,1.0};
float4 SurfaceColor  <bool color=true;String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
float4 LampColor  <bool color=true;String uiname="Specular";>  = {0.7, 0.7, 1,1};
float4 LampDirPos <string uiname="Light Direction";> = {-0.5f,2.0f,1.25f,1.0};
float Alpha <float uimin=0.0; float uimax=1;> = 1;	
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;

TextureCube EnvTexture <string uiname="EnvTexture"; >; 
Texture2D Texture2d <string uiname="NormalTexture"; >; 
Texture2D BumpT <string uiname="BumpTexture"; >; 
SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

SamplerState g_samLinearCube
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
    AddressW = Clamp;
};


bool FLIP_TEXTURE_Y;
bool OBJECT_SPACE_LIGHTS;

struct vs2ps
{
    float4 HPosition	: SV_POSITION;
    float2 UV		: TEXCOORD0;
    float3 LightVec	: TEXCOORD1;
    float3 WorldNormal	: TEXCOORD2;
   float3 WorldTangent	: TEXCOORD3;
    float3 WorldBinormal : TEXCOORD4;
    float3 WorldView	: TEXCOORD5;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
    float4 Tangent	: TANGENT0;
    float4 Binormal	: BINORMAL0;
};

vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

	Out.WorldNormal = mul(In.Normal,tW).xyz;
    Out.WorldTangent = mul(In.Tangent,tW).xyz;
	Out.WorldBinormal = mul(In.Binormal,tW).xyz;
	
    float4 Po = float4(In.Position.xyz,1);
	float4 Lo = float4(LampDirPos.xyz,1.0); // homogeneous coordinates
    float4 Pw = mul(Po,tW);	// convert to "world" space
	float4 Lw=mul(Lo,tW);
	 if(OBJECT_SPACE_LIGHTS==false)
	{
     Lw = LampDirPos;
	}
    if (Lw.w == 0) 
	{
	Out.LightVec = -normalize(Lw.xyz);
    } 
	else 
	{
	// we are still passing a (non-normalized) vector
	Out.LightVec = Lw.xyz - Pw.xyz;
    }
	
if(FLIP_TEXTURE_Y==true) 
	{ 
      Out.UV = In.UV.x,(1.0-In.UV.y);
	}
else //* !FLIP_TEXTURE_Y */
	{
    Out.UV = In.UV.xy;
	}

    Out.WorldView = normalize(tVI[3].xyz - Pw.xyz);
    Out.HPosition = mul(Po,tWVP);


    
    return Out;
}







float4 PS(vs2ps In): SV_Target
{

// "standard" normalized vectors....
    float3 Ln = normalize(In.LightVec);
    float3 Vn = normalize(In.WorldView);
    float3 Nn = normalize(In.WorldNormal);
    float3 Tn = normalize(In.WorldTangent);
    float3 Bn = normalize(In.WorldBinormal);
    float3 bump = Bump1 * BumpT.Sample(g_samLinear,In.UV).xyz - float3(0.5,0.5,0.5);
    Nn = Nn + bump.x*Tn + bump.y*Bn;
    Nn = normalize(Nn);
    float3 Hn = normalize(Vn + Ln);
    float hdn = dot(Hn,Nn);
    float3 Rv = reflect(-Ln,Nn);
    float rdv = dot(Rv,Vn);
    rdv = max(rdv,0.001);
    float ldn=dot(Ln,Nn);
    ldn = max(ldn,0.0);
    float ndv = dot(Nn,Vn);
    float hdv = dot(Hn,Vn);
    float eSq = Eccentricity*Eccentricity;
    float distrib = eSq / (rdv * rdv * (eSq - 1.0) + 1.0);
    distrib = distrib * distrib;
    float Gb = 2.0 * hdn * ndv / hdv;
    float Gc = 2.0 * hdn * ldn / hdv;
    float Ga = min(1.0,min(Gb,Gc));
    float fresnelHack = 1.0 - pow(ndv,5.0);
    hdn = distrib * Ga * fresnelHack / ndv;
    float3 diffContrib = ldn * LampColor.xyz;
    float3 specContrib = hdn * Ks * LampColor.xyz;
    float3 diffuseColor = Texture2d.Sample(g_samLinear,In.UV).xyz;
    float3 result = specContrib+(diffuseColor*(diffContrib+AmbiColor.xyz));
    float3 R = reflect(Vn,Nn);
	float3 reflColor = Kr * EnvTexture.Sample(g_samLinearCube,R.xyz).rgb;
    
    result += diffuseColor*reflColor;

    return float4(result,Alpha);
    
}





technique10 blinn
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

