

float4x4 tW: WORLD;
float4x4 tWI: WORLDINVERSE;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tVT:VIEWTRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tWVI: WORLDVIEWINVERSE;
float4x4 tP: PROJECTION;

float SpecExpon <float uimin=1.0; float uimax=128;> = 1.0;

float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,1.0};
float4 LampColor  <bool color=true;String uiname="LampColor";>  = {0.85, 0.85, 0.85, 1};

float3 LampPos <string uiname="Light Direction";> = {0.7f,-0.7f,-0.7f};

float Alpha <float uimin=0.0; float uimax=1;> = 1;	
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;



Texture2D paintMap <string uiname="paintMap"; >; 

Texture2D texture2d <string uiname="texture2D"; >; 

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};


struct vs2ps
{
    float4 HPosition	: SV_POSITION;
    float2 BrdfTerms	: TEXCOORD0; // dot prods against half-angle
    float2 UV	: TEXCOORD2;
    float3 WorldNormal : TEXCOORD3;
    float3 WorldView : TEXCOORD4;
    float3 LightVec : TEXCOORD5;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
    //float4 Tangent	: TANGENT0;
    //float4 Binormal	: BINORMAL0;
};

vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

    float4 Po = float4(In.Position.xyz,1);
    float3 Pw = mul(Po,tW).xyz;
    float3 Lw = (LampPos - Pw);
    float3 Ln = normalize(Lw);
    float3 EyePos = tVI[3].xyz;
    float3 Vw = (EyePos - Pw);
    float3 Vn = normalize(Vw);
    float3 Nn = normalize(mul(In.Normal,tW).xyz);
    Nn = faceforward(Nn,-Vn,Nn);
    float ldn = dot(Ln,Nn);
    float3 Hn = normalize(Vn + Ln);
    float aldn = abs(dot(Ln,Nn));
    float ahdn = 1.0-abs(dot(Hn,Nn));
    Out.WorldNormal = Nn;
    Out.LightVec = Lw;
    Out.WorldView = Vw;
    Out.BrdfTerms = float2(aldn,ahdn);
    Out.HPosition = mul(Po,tWVP);
    Out.UV = In.UV.xy;
  

    return Out;
}

float4 brdf_texture(vs2ps In) {
    return paintMap.Sample(g_samLinear,In.BrdfTerms);
}

float4 colorOnlyPS(vs2ps In) : SV_Target
{
    return brdf_texture(In);
}




float4 litPS_PS(vs2ps In): SV_Target
{

	float3 surfCol = brdf_texture(In).rgb;
    float3 Ln = normalize(In.LightVec);
    float3 Vn = normalize(In.WorldView);
    float3 Nn = normalize(In.WorldNormal);
    Nn = faceforward(Nn,-Vn,Nn);
    float ldn = dot(Nn,Ln);
    float3 Hn = normalize(Vn + Ln);
    float hdn = dot(Hn,Ln);
    float4 litV = lit(ldn,hdn,SpecExpon);
	float3 ColTex = texture2d.Sample(g_samLinear,In.UV).xyz;
    float3 d = surfCol * (litV.yyy + AmbiColor.xyz);
    float3 s = litV.y * litV.z * (LampColor.xyz);
    return float4((d+s).rgb*ColTex,Alpha);
	
    
}


technique10 TcolorOnly
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, colorOnlyPS() ) );
	}
}
technique10 TlitPS
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, litPS_PS() ) );
	}
}
