

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tP: PROJECTION;

float Ks <float uimin=0.0; float uimax=1;> = 0.4;
float Kr <float uimin=0.0; float uimax=1;> = 0.5;
float Bump <float uimin=0.0; float uimax=3.0;> = 1.0;

float GlossTop <float uimin=0.1; float uimax=0.95;> = 0.65;
float GlossDrop <float uimin=0.0; float uimax=1.0;> = 0.25;
float GlossEdge <float uimin=0.0; float uimax=0.5;> = 0.25;
float SpecExpon <float uimin=1.0; float uimax=128;> = 30;

float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,1.0};
float4 SurfaceColor  <bool color=true;String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};

float4 WarmColor  <bool color=true;String uiname="Gooch Warm Tone";>  = {0.5f, 0.4f, 0.05f,1};
float4 CoolColor  <bool color=true;String uiname="Gooch Cool Tone";>  = {0.05f, 0.05f, 0.6f,1};



float4 LampColor  <bool color=true;String uiname="Specular";>  = {0.7, 0.7, 0.6, 1};
float4 LampDirPos <string uiname="Light Direction";> = {0, -5, 2,1}; 
float Alpha <float uimin=0.0; float uimax=1;> = 1;	
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;



TextureCube EnvTexture <string uiname="EnvTexture"; >; 
Texture2D normalTexture <string uiname="NormalTexture"; >; 

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

SamplerState g_samLinearCube
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
    AddressW = Clamp;
};

bool FLIP_TEXTURE_Y;
bool OBJECT_SPACE_LIGHTS;

struct vs2ps
{
    float4 HPosition	: SV_POSITION;
    float2 UV		: TEXCOORD0;
    float3 LightVec	: TEXCOORD1;
    float3 WorldNormal	: TEXCOORD2;
	  
    float3 WorldTangent	: TEXCOORD3;
    float3 WorldBinormal : TEXCOORD4;
    float3 WorldView	: TEXCOORD5;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
    float4 Tangent	: TANGENT0;
    float4 Binormal	: BINORMAL0;
};

vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

	Out.WorldNormal = mul(In.Normal,tW).xyz;
    Out.WorldTangent = mul(In.Normal,tW).xyz;
	Out.WorldBinormal = mul(In.Normal,tW).xyz;
	
	
	
    float4 Po = float4(In.Position.xyz,1);
    float4 Pw = mul(Po,tW);	// convert to "world" space
	float4 Lw=mul(LampDirPos,tW);
	    if(OBJECT_SPACE_LIGHTS==false)
	{
     Lw = LampDirPos;
	}
    if (Lw.w == 0) 
	{
	Out.LightVec = -normalize(Lw.xyz);
    } 
	else 
	{
	// we are still passing a (non-normalized) vector
	Out.LightVec = Lw.xyz - Pw.xyz;
    }
	
if(FLIP_TEXTURE_Y==true) 
	{ 
     Out.UV = mul(float2(In.UV.x,(1.0-In.UV.y)),(float2x2)tTex);
	}
else //* !FLIP_TEXTURE_Y */
	{
    Out.UV = mul(In.UV.xy,(float2x2)tTex);
	}

    Out.WorldView = normalize(tVI[3].xyz - Pw.xyz);
    Out.HPosition = mul(Po,tWVP);


    
    return Out;
}

// Utility function for gooch shading

float glossy_drop(float v,
	uniform float top,
	uniform float bot,
	uniform float drop)
{
    return (drop+smoothstep(bot,top,v)*(1.0-drop));
}




float4 PS(vs2ps In): SV_Target
{

	 // "standard" normalized vectors....
    float3 Ln = normalize(In.LightVec);
    float3 Vn = normalize(In.WorldView);
    float3 Nn = normalize(In.WorldNormal);
    float3 Tn = normalize(In.WorldTangent);
    float3 Bn = normalize(In.WorldBinormal);
    float3 bump = Bump * (normalTexture.Sample(g_samLinear,In.UV).rgb - float3(0.5,0.5,0.5));
    Nn = Nn + bump.x*Tn + bump.y*Bn;
    Nn = normalize(Nn);
    float3 Hn = normalize(Vn + Ln);
    float ldn = dot(Ln,Nn);
    float hdn = dot(Hn,Nn);
    float4 litV = lit(ldn,hdn,SpecExpon);
    float goochFactor = (1.0 + ldn) / 2.0;
    float3 toneColor = lerp(CoolColor,WarmColor,goochFactor);
    float3 diffContrib = toneColor;
    // now to add glossiness...
    float spec = litV.y * litV.z;
    spec *= glossy_drop(spec,GlossTop,(GlossTop-GlossEdge),GlossDrop);
    float3 specContrib = spec * Ks * LampColor;
    float3 diffuseColor = SurfaceColor;
    float3 result = specContrib+(diffuseColor*(diffContrib+AmbiColor));
    float3 R = reflect(Vn,Nn);
    float3 reflColor = Kr * EnvTexture.Sample(g_samLinearCube,R.xyz).rgb;
    result += diffuseColor*reflColor;
	

    return float4(result,Alpha);
    
}

technique10 gooch_bump_reflect
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

