

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tP: PROJECTION;



float RollOff <float uimin=0.0; float uimax=0.99;> = 0.2;



float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,0.8};
float4 SurfaceColor  <bool color=true;String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 0.9};
float4 DiffColor  <bool color=true;String uiname="Surface Diffuse";>  = {0.07f,0.07f,0.07f,0.8};
float4 SubColor <bool color=true;String uiname="Subsurface 'Bleed-thru'";>  = {1.0f, 0.2f, 0.2f,0.};
float4 LampColor  <bool color=true;String uiname="Specular";>  = {0.7, 0.7, 0.6, 1};

float3 LampPos <string uiname="Light Direction";> = {0, -0.9,1}; 

float Alpha <float uimin=0.0; float uimax=1;> = 1;	

float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;

Texture2D ColorTexture <string uiname="Texture"; >; 

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

bool FLIP_TEXTURE_Y;
bool OBJECT_SPACE_LIGHTS;

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
   // float4 Tangent	: TANGENT0;
   // float4 Binormal	: BINORMAL0;
};

struct vs2ps
{
    float4 HPosition	: SV_POSITION;
    float2 UV		: TEXCOORD0;
    float3 LightVec	: TEXCOORD1;
    float3 WorldNormal	: TEXCOORD2;  
    //float3 WorldTangent	: TEXCOORD3;
    //float3 WorldBinormal : TEXCOORD4;
    float3 WorldView	: TEXCOORD3;
	float4 diffCol	: COLOR1;

};

void lambskin(float3 N,
	      float3 L,
	      float3 DiffColor,
	      float3 SubColor,
	      float RollOff,
	      out float3 Diffuse,
	      out float3 Subsurface
) {
    float ldn = dot(L,N);
    float diffComp = max(0,ldn);
    Diffuse = diffComp * DiffColor;
    float subLamb = smoothstep(-RollOff,1.0,ldn) - smoothstep(0.0,1.0,ldn);
    subLamb = max(0.0,subLamb);
    Subsurface = subLamb * SubColor;
}

vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

	Out.WorldNormal = mul(In.Normal,tW).xyz;
   // Out.WorldTangent = mul(In.Tangent,tWVIT).xyz;
   // Out.WorldBinormal = mul(In.Binormal,tWVIT).xyz;
    float4 Po = float4(In.Position.xyz,1); // homogeneous location
    float4 Pw = mul(Po,tW);	// convert to "world" space
 if(OBJECT_SPACE_LIGHTS==false)
	{
    float4 Lo = float4(LampPos.xyz,1.0); // homogeneous coordinates
    float4 Lw = mul(Lo,tW);	// convert to "world" space
    Out.LightVec = (Lw.xyz - Pw.xyz);
	}
else
	{
    Out.LightVec = (LampPos - Pw.xyz);
    }
	
	if(FLIP_TEXTURE_Y==true) 
	{ 
     Out.UV = mul(float2(In.UV.x,(1.0-In.UV.y)),(float2x2)tTex);
	}
else //* !FLIP_TEXTURE_Y */
	{
    Out.UV = mul(In.UV.xy,(float2x2)tTex);
	}

    Out.WorldView = normalize(tVI[3].xyz - Pw.xyz);
    Out.HPosition = mul(Po,tWVP);
  
	float3 Nn = normalize(mul(In.Normal,tW).xyz);
    float3 Ln = normalize(LampPos - Pw);
    float3 diffContrib;
    float3 subContrib;
	lambskin(Nn,Ln,
		DiffColor,SubColor,RollOff,
		diffContrib,subContrib);
    Out.diffCol.rgb = diffContrib + AmbiColor + subContrib;
    Out.diffCol.a = 1.0;

    return Out;
}

void lamb_ps_shared(vs2ps In,
		     float3 DiffColor,
		     float3 SubColor,
		     float RollOff,
		     out float3 DiffuseContrib,
		     out float3 SubContrib)
{
    float3 Ln = normalize(In.LightVec.xyz);
    float3 Nn = normalize(In.WorldNormal.xyz);
    lambskin(Nn,Ln,
		DiffColor,SubColor,RollOff,
		DiffuseContrib,SubContrib);
}



float4 PS(vs2ps In): SV_Target
{
	
	
	float3 diffContrib;
	float3 subContrib;
	lamb_ps_shared(In,DiffColor.xyz,SubColor.xyz,RollOff,diffContrib.xyz,subContrib.xyz);
	float3 litC = diffContrib + AmbiColor.xyz + subContrib;
	
	float4 T = ColorTexture.Sample(g_samLinear,In.UV);
	return float4(litC.rgb*T.rgb,Alpha);
	
	
    
}

float4 lambPS_pass(vs2ps In): SV_Target
{

    return In.diffCol;
}


technique10 TlambSkin
{
	pass P0
	{
		
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}


technique10 TlambSkinPass
{
	pass P0
	{
		
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, lambPS_pass() ) );
	}
}
