

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tP: PROJECTION;

float LampIntensity <float uimin=0.0; float uimax=1000.0;> = 1;

float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,1.0};
float4 SurfaceColor  <bool color=true;String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
float4 LampColor  <bool color=true;String uiname="Specular";>  = {0.7, 0.7, 0.6, 1};
float4 LampDirPos <string uiname="Light Direction";> = {0, -5, 2,1}; 
float Alpha <float uimin=0.0; float uimax=1;> = 1;	
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;



Texture2D texture2d <string uiname="Texture"; >; 

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

bool FLIP_TEXTURE_Y;
bool OBJECT_SPACE_LIGHTS;

struct vs2ps
{
    float4 HPosition	: SV_POSITION;
    float2 UV		: TEXCOORD0;
    float3 LightVec	: TEXCOORD1;
    float3 WorldNormal	: TEXCOORD2;
    float3 WorldView	: TEXCOORD5;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
    //float4 Tangent	: TANGENT0;
    //float4 Binormal	: BINORMAL0;
};

vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

	Out.WorldNormal = mul(In.Normal,tW).xyz;

    float4 Po = float4(In.Position.xyz,1);
    float4 Pw = mul(Po,tW);	// convert to "world" space
	float4 Lw=mul(LampDirPos,tW);
	    if(OBJECT_SPACE_LIGHTS==false)
	{
     Lw = LampDirPos;
	}
    if (Lw.w == 0) 
	{
	Out.LightVec = -normalize(Lw.xyz);
    } 
	else 
	{
	// we are still passing a (non-normalized) vector
	Out.LightVec = Lw.xyz - Pw.xyz;
    }
	
if(FLIP_TEXTURE_Y==true) 
	{ 
      Out.UV = mul(float2(In.UV.x,(1.0-In.UV.y)),tTex);
	}
else //* !FLIP_TEXTURE_Y */
	{
    Out.UV = mul(In.UV.xy,tTex);
	}

    Out.WorldView = normalize(tVI[3].xyz - Pw.xyz);
    Out.HPosition = mul(Po,tWVP);


    
    return Out;
}

void lambert_shared(vs2ps In,
			float3 LightColor,
			float3 AmbiColor,
			out float3 DiffuseContrib)
{
    float3 Ln = normalize(In.LightVec);
    float3 Nn = normalize(In.WorldNormal);
    float ldn = dot(Ln,Nn);
    ldn = max(ldn,0);
    DiffuseContrib = ldn * LightColor + AmbiColor;
}



float4 PS(vs2ps In): SV_Target
{

	float3 diffContrib;
	lambert_shared(In,LampColor,AmbiColor,diffContrib);
    float3 map = texture2d.Sample(g_samLinear,In.UV).xyz;
    float3 result = (SurfaceColor * map * diffContrib);
    return float4(result,Alpha);
    
}



float4 lambertQ_PS(vs2ps In): SV_Target
{

	float3 diffContrib;
    float3 Cl = (LampIntensity/dot(In.LightVec,In.LightVec)) * LampColor;
    lambert_shared(In,Cl,AmbiColor,diffContrib);
    float3 map = texture2d.Sample(g_samLinear,In.UV).xyz;
    float3 result = (SurfaceColor * map * diffContrib);
    return float4(result,Alpha);
	
    
}

technique10 lambert
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

technique10 lambertQ
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, lambertQ_PS() ) );
	}
}