

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tP: PROJECTION;

float Kd <float uimin=0.0; float uimax=1;> = 0.9;
float Ks <float uimin=0.0; float uimax=1;> = 0.4;
float SpecExpon <float uimin=1.0; float uimax=128;> = 1.0;
float SubExpon <float uimin=1.0; float uimax=10.0;> = 4.0;
float Transp <float uimin=0.0; float uimax=1;> = 1;	

float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,1.0};
float4 SurfaceColor  <bool color=true;String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
float4 LampColor  <bool color=true;String uiname="Specular";>  = {0.7, 0.7,0.85, 1};
float4 LampDirPos <string uiname="Light Direction";> = {-0.5f,2.0f,1.25f,1.0};
float Alpha <float uimin=0.0; float uimax=1;> = 1;	

float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;
float4x4 tTexSub <bool uvspace=true; string uiname="Texture TransformSub";>;
Texture2D texture2d <string uiname="Texture"; >; 
Texture2D SubTexture <string uiname="SubTexture"; >;

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

bool FLIP_TEXTURE_Y;
bool OBJECT_SPACE_LIGHTS;

struct vs2ps
{
    float4 HPosition	: SV_POSITION;
    float2 UV		: TEXCOORD0;
    float3 LightVec	: TEXCOORD1;
    float3 WorldNormal	: TEXCOORD2;
	float2 UVSub	: TEXCOORD3;
    float3 WorldView	: TEXCOORD5;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
    //float4 Tangent	: TANGENT0;
    //float4 Binormal	: BINORMAL0;
};

vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

	Out.WorldNormal = mul(In.Normal,tW).xyz;

    float4 Po = float4(In.Position.xyz,1);
	
    float4 Pw = mul(Po,tW);	// convert to "world" space
	float4 Lw=mul(LampDirPos,tW);
	if(OBJECT_SPACE_LIGHTS==true)
	{
	float4 Lw = mul(LampDirPos,tW);	// convert to "world" space 
	} 
	else 
	{
    float4 Lw = LampDirPos;
    }
    if (Lw.w == 0) 
	{
	Out.LightVec = -normalize(Lw.xyz);
    } 
	else 
	{
	// we are still passing a (non-normalized) vector
	Out.LightVec = Lw.xyz - Pw.xyz;
    }
	
if(FLIP_TEXTURE_Y==true) 
	{ 
      Out.UV = mul(float2(In.UV.x,(1.0-In.UV.y)),tTex);
	  Out.UVSub = mul(float2(In.UV.x,(1.0-In.UV.y)),tTexSub);
	}
else //* !FLIP_TEXTURE_Y */
	{
    Out.UV = mul(In.UV.xy,tTex);
	Out.UVSub = mul(In.UV.xy,tTexSub);
	}

    Out.WorldView = normalize(tVI[3].xyz - Pw.xyz);
    Out.HPosition = mul(Po,tWVP);
  
    return Out;
}


float4 PS(vs2ps In): SV_Target
{

	float3 Ln = normalize(In.LightVec.xyz);
    float3 Vn = normalize(In.WorldView);
    float3 Nn = normalize(In.WorldNormal);
    float3 Hn = normalize(Vn + Ln);
    float ldn = dot(Ln,Nn);
    float4 lv = lit(ldn,dot(Hn,Nn),SpecExpon);
    float subd = abs(dot(Nn,Vn));
    subd = Transp * pow(subd,SubExpon);
    float3 colT = SurfaceColor * texture2d.Sample(g_samLinear,In.UV).xyz;
    float3 subT = SubTexture.Sample(g_samLinear,In.UVSub.xy).xyz;;
    subT = subT * max(0,ldn);
    float3 blendCol = lerp(colT,subT,subd);
    float3 diffContrib = blendCol * (lv.y*LampColor + AmbiColor);
    float3 specContrib = Ks * lv.z * LampColor;

    return float4((diffContrib + specContrib).rgb,Alpha);

    
}



technique10 TSubcutaneous
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

