//@author: vvvv group
//@help: draws a mesh with a constant color
//@tags: template, basic
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tWV: WORLDVIEW;
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (EX9)
float4x4 tWVP: WORLDVIEWPROJECTION;

float4x4 tWVInverseTranspose : WORLDVIEWINVERSETRANSPOSE; //for bringing normals into viewspace

//material properties
float4 cAmb : COLOR <String uiname="Color";>  = {1, 1, 1, 1};
float Alpha = 1;
float2 fadeAngleFromTo = {0.1, 0.2};

//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;
float4x4 tColor <string uiname="Color Transform";>;

//the data structure: vertexshader to pixelshader
//used as output data with the VS function
//and as input data with the PS function
float mapToNormal (float value, float2 range) 
{
	//replace 0 and 1 with to.x and to.y to get a from-to mapping function
	float output = ((value - range.x) / (range.y - range.x)) * (1 - 0) + 0;
	output = max(0.0, output);
	output = min (1.0, output);
	
	return output;
}

struct vs2ps
{
    float4 Pos : POSITION;
    float4 TexCd : TEXCOORD0;
	float4 angle : TEXCOORD1;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
    float4 Pos : POSITION,
    float4 TexCd : TEXCOORD0,
	float3 NormO : NORMAL)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

	
		//put normals in viewspace (not quite correct, would need the inverse-transpose matrix, but whothehell cares about non-uniform scaling in viewspace? haha)
//	float3 NormWV = normalize(mul(NormO, (float3x3)tWV));
	
	
	float3 NormWV = mul(NormO, (float3x3)tWVInverseTranspose);
	NormWV = normalize(NormWV);
	
	float4 PosWV = mul(Pos, tWV);
	
	//get normalized vector from position to origin (where the camera is)
	float4 toOrigin = normalize( -PosWV);
	Out.angle.x = dot( NormWV, toOrigin);
	
//	Out.angle.x = 1;
	
	
    //transform position
    Out.Pos = mul(Pos, tWVP);

    //transform texturecoordinates
    Out.TexCd = mul(TexCd, tTex);

	
	//calculate angle between Normal and viewspace zaxis
	//Out.angle.x = acos( dot( NormWVP, float3(0.0, 0.0, 1.0))) / 3.14;
	

    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(vs2ps In): COLOR
{
    //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0

    float4 col = tex2D(Samp, In.TexCd) * cAmb;
    col = mul(col, tColor);
	
	
	//float2 range = float2(0.2, 0.4);
	if(In.angle.x > fadeAngleFromTo.y)
		col.a *= 1;
	else if (In.angle.x <= fadeAngleFromTo.y && In.angle.x >= fadeAngleFromTo.x){
		//fade!
		col.a *= mapToNormal(In.angle.x, fadeAngleFromTo);
	}
	else 
		col.a *= 0;
		
	col.a *= Alpha;
		
    return col;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TConstant
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_2_0 VS();
        PixelShader = compile ps_2_0 PS();
    }
}

technique TConstantFF
{
    pass P0
    {
        //transformations
        WorldTransform[0]   = (tW);
        ViewTransform       = (tV);
        ProjectionTransform = (tP);

        //material
        MaterialAmbient  = {1, 1, 1, 1};
        MaterialDiffuse  = {1, 1, 1, 1};

        //texturing
        Sampler[0] = (Samp);
        TextureTransform[0] = (tTex);
        TexCoordIndex[0] = 0;
        TextureTransformFlags[0] = COUNT4 | PROJECTED;
        //Wrap0 = U;  // useful when mesh is round like a sphere

        //lighting
        LightEnable[0] = TRUE;
        Lighting       = TRUE;
        SpecularEnable = FALSE;

        LightType[0]     = DIRECTIONAL;
        LightAmbient[0]  = (cAmb);
        LightDiffuse[0]  = {0, 0, 0, 0};
        LightDirection[0] = {0, 0, 1, 1};

        //shading
        ShadeMode = FLAT;
        VertexShader = NULL;
        PixelShader  = NULL;
    }
}

