// this is an effect template. use it to start writing your own effects.

// -------------------------------------------------------------------------------------------------------------------------------------
// PARAMETERS:
// -------------------------------------------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tWV: WORLDVIEW;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (DX9)
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (DX9)
float4x4 tWVP: WORLDVIEWPROJECTION;

float Alpha = 1;
float LodBias = -1;
//float3 ProjectorPosition = 0;
//texture
texture Tex <string uiname="Texture";>;
float4x4 tTex <string uiname="Texture Transform";>;                  //Texture Transform

float4x4 ProjectorV =
float4x4(
 1.0, 0.0,  0.0,  0.0,
 0.0, 1.0,  0.0,  0.0,
 0.0, 0.0,  1.0,  0.0,
 0.0, 0.0,  0.0,  1.0
);

float4x4 ProjectorP =
float4x4(
 0.5,  0.0,  0.0,  0.0,
 0.0, -0.5,  0.0,  0.0,
 0.0,  0.0,  1.0,  0.0,
 0.5,  0.5,  0.0,  1.0
);


//tTex = mul ( tTex , RCtoTC );
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = ANISOTROPIC;         //set the sampler states
    MinFilter = ANISOTROPIC;
    MagFilter = ANISOTROPIC;
    // BorderColor = { 1.0, .0, 1.0, .0 }; // what to do with border color? alpha does not respond ...
    AddressU = Border;           /////////
    AddressV = Border;           /////////  vorher Clamp, so ein Quatsch
    MipMapLodBias = (LodBias);
};


// -------------------------------------------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// -------------------------------------------------------------------------------------------------------------------------------------

struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float4 TexC : TEXCOORD0;
	float3 normProjectorV : TEXCOORD1;
};

VS_OUTPUT VS(
    float4 Pos  : POSITION,
    float4 TexC : TEXCOORD,
	float3 NormO: NORMAL)
{
    //inititalize all fields of output struct with 0
    VS_OUTPUT Out = (VS_OUTPUT)0;
	
	//view matrix of the projector * projection matrix of the projector
	float4x4 ProjectorVP = mul(ProjectorV, ProjectorP);
	//RCtoTC needs to be multiplied by this matrix
	//compare TextureSpace (Transform FromProjectionSpace)
	float4x4 RCtoTC =
float4x4(
 0.5,  0.0,  0.0,  0.0,
 0.0, -0.5,  0.0,  0.0,
 0.0,  0.0,  1.0,  0.0,
 0.5,  0.5,  0.0,  1.0
);
	RCtoTC = mul(ProjectorVP, RCtoTC); 
	
    //transform texturecoordinates
    tTex = mul (RCtoTC, tTex   );
    TexC = Pos;
    
    TexC = mul(TexC, tW);
    TexC = mul(TexC, tTex);
    
    Out.TexC = TexC;
	
	//normal in World Space
	float3 NormW = normalize( mul(NormO, (float3x3)tW) );
	
	// normal in the eye space of the PROJECTOR (comp to light source)
	Out.normProjectorV = mul(NormW, ProjectorV);
	
    //transform position
    Pos = mul(Pos, tWVP);
	//Pos= mul(Pos, tW);
	//Pos = mul(Pos, tV);
	//Pos = mul(Pos, tP);
	
	//q&d! this only makes sure that the projected texture is in front of the actual texture (had problems with lessorequal
    Pos.z -= 0.00001;
	Out.Pos  = Pos;
		
    return Out;
}

// -------------------------------------------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// -------------------------------------------------------------------------------------------------------------------------------------

float4 PS(float4 TexC: TEXCOORD0, VS_OUTPUT input): COLOR
{
    float4 col = tex2Dproj(Samp, TexC);

    //if( TexC.w>0.0 )
	//if the object is in front of the projector, not behind
    if( TexC.w > 0.0 )
    {
    TexC.xyz = TexC.xyz / TexC.w;
    //multiply by given Alpha value
    col.a *= Alpha;
    	
    //show only if projection comes from the front
    //no back projection possible ;)
    if(input.normProjectorV.z > 0) 	col.a = 0;

    	
    //for more reality (projections are brighter when the angle is steeper)
    col.a *= pow( abs(input.normProjectorV.z), 0.5);

    }
    else col = 0;
    
    // below: kill all color outside of original texture.
    if( TexC.x < 0 || TexC.y < 0 || TexC.x > 1 || TexC.y > 1 )
    {
    col = 0;
    }

    return col;
}

// -------------------------------------------------------------------------------------------------------------------------------------
// TECHNIQUES:
// -------------------------------------------------------------------------------------------------------------------------------------

technique TSimpleShader
{
    pass P0
    {

       // TextureTransformFlags[0] = COUNT3 | PROJECTED;
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
