


TextureCube tex0 <string uiname="Environment Texture";>;
SamplerState Sampler

{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};



cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;	
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tWIT: WORLDINVERSETRANSPOSE;
	float4x4 tWVP: WORLDVIEWPROJECTION;
	float4x4 tVI:VIEWINVERSE;
	float4x4 tW: WORLD;
	
	float3 lPos <string uiname="Light Direction";> ={0,-5,2};
	float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;
	float4 AmbiCol <bool color=true;String uiname="Ambient Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 SurfCol <bool color=true;String uiname="Diffuse Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 lCol <bool color=true;String uiname="Specular Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float SpecExpon <string uiname="Power";float uimin=1.0;float uimax=128.0;> =60;
	float Kd <string uiname="Diffuse ";float uimin=0.0;float uimax=1.0;> =0.5;
	float Kr <string uiname="Reflection";float uimin=0.0;float uimax=2.0;> =.8;
	float FresnelMin <string uiname="Fresnel Reflection Scale";float uimin=0.0;float uimax=1.0;> =.05;
	static float KrMin=(Kr*FresnelMin);
	float FresnelExp <string uiname="Fresnel Exponent";float uimin=0.0;float uimax=6.0;> =3.5;
	static float InvFrExp = (1.0/FresnelExp);

};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;
	float4 NormO : NORMAL;
};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float4 TexCd: TEXCOORD0;
	float3 LightVec:TEXCOORD1;
    float3 WorldNormal:TEXCOORD2;
    float3 WorldView:TEXCOORD5;
};

vs2ps VS(VS_IN input)
{
    vs2ps Out = (vs2ps)0;
    float4 normal=normalize(input.NormO);
	Out.WorldNormal=mul(normal,tWIT).xyz;
	float4 Po=float4(input.PosO.xyz,1);
	float3 Pw=mul(Po,tW).xyz;
	Out.LightVec=normalize(lPos-Pw);
	Out.WorldView=normalize(tVI[3].xyz-Pw);

	
	Out.PosWVP  = mul(input.PosO,mul(tW,tVP));
    Out.TexCd = input.TexCd;
    return Out;
}


float4 psMETAL(vs2ps In): SV_Target
{
    float3 Ln=normalize(In.LightVec);
	float3 Nn=normalize(In.WorldNormal);
    float3 Vn=normalize(In.WorldView);
	float3 Hn=normalize(Vn+Ln);
	float4 litV=lit(dot(Ln,Nn),dot(Hn,Nn),SpecExpon);
	float3 reflVect=-reflect(Vn,Nn);
   
	float4 diffContrib=litV.y*Kd*lCol+AmbiCol;
	float4 specContrib=litV.z*lCol;
	float4 reflColor=Kr*tex0.Sample(Sampler,reflVect).xyzw;
	
	float4 result = diffContrib+(SurfCol*(specContrib+reflColor));
	
    return result;
}


float4 psPLASTIC(vs2ps In): SV_Target
{
    float3 Ln=normalize(In.LightVec);
	float3 Nn=normalize(In.WorldNormal);
    float3 Vn=normalize(In.WorldView);
	float3 Hn=normalize(Vn+Ln);
	float4 litV=lit(dot(Ln,Nn),dot(Hn,Nn),SpecExpon);
	float3 reflVect=-reflect(Vn,Nn);
   
	float4 diffContrib=litV.y*Kd*lCol+AmbiCol;
	float4 specContrib=litV.z*lCol;
	float4 reflColor=Kr*tex0.Sample(Sampler,reflVect).xyzw;
	
	float fresnel=lerp(Kr,KrMin,pow(abs(dot(Nn,Vn)),InvFrExp));
	float4 result = (diffContrib*SurfCol)+specContrib+(fresnel*reflColor);
	
    return result;
}


technique10 Metal
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, psMETAL() ) );
	}
}





technique10 Plastic
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, psPLASTIC() ) );
	}
}




