#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using VVVV.PluginInterfaces.V2.Graph;
using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "KontrolleurGetValues", Category = "vvvv", Help = "Basic template with one string in/out", Tags = "")]
	#endregion PluginInfo
	public class vvvvKontrolleurGetValuesNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Address", DefaultString = "")]
		ISpread<string> FInput;

		[Input("Update", IsBang = true)]
		IDiffSpread<bool> FUpdate;
		
		


		[Output("Values")]
		ISpread<string> FValues;

//		[Output("Node Name")]
//		public ISpread<string> FNodeName;

		[Import()]
		IHDEHost FHDEHost;
		#endregion fields & pins
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FValues.SliceCount = SpreadMax;


			for (int i = 0; i < SpreadMax; i++) {
				var nodePath = FInput[i].Substring(0, FInput[i].LastIndexOf('/'));
				var node = FHDEHost.GetNodeFromPath(nodePath);

				if (FUpdate[i]) {
					if (node != null) {

						var parts = FInput[i].Split('/');
						var pin = node.FindPin(parts[parts.Length - 1]);

							FValues[i] = pin.Spread;

					}
				}
			}
		}
}	
}
