//@author: sebl
//@help: inigo quilez' nautilus shader
//@tags: raymarching, shadertoy
//@credits: inigo quilez - iq/2013
//@license: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.


SamplerState linearSampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};
 
cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;	
	float time;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float4 TexCd: TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP  = mul(input.PosO,mul(tW,tVP));
    output.TexCd = input.TexCd;
    return output;
}



float e(float3 c)
{
    c = cos(float3(cos(c.r+time/6.0)*c.r-cos(c.g*3.0+time/5.0)*c.g, cos(time/4.0)*c.b/3.0*c.r-cos(time/7.0)*c.g, c.r+c.g+c.b+time));
    return dot(c*c,float3(1.0,1.0,1.0))-1.0;
}


float4 PSNautilus(vs2ps In): SV_Target
{
    float2 c = -1.0+2.0*In.TexCd.rg;
    float3 o = float3(c.r,c.g,0.0);
	float3 g = float3(c.r,c.g,1.0)/64.0;
	float3 v = float3(0.5,0.5,0.5);
    float  m = 0.4;

    for(int r = 0;r < 100; r++)
    {
      float h = e(o)-m;
      if(h < 0.0) break;
      o += h*10.0*g;
      v += h*0.02;
    }
	
    // light (who needs a normal?)
    v += e(o+0.1)*float3(0.4,0.7,1.0);

    // ambient occlusion
    float a = 0.0;
    for(int q = 0; q < 100; q++)
    {
       float l = e(o+0.5*float3(cos(1.1*float(q)),cos(1.6*float(q)),cos(1.4*float(q))))-m;
       a += clamp(4.0*l,0.0,1.0);
    }
	
    v *= a/100.0;
    return float4(v,1.0);
}    

float4 PSNautilusOrig (vs2ps In): SV_Target
{
	float2 c = -1.0 + 2.0*In.TexCd.rg;
    float3 o = float3(c.r, c.g+cos(time/2.0) / 30.0, 0);
	float3 g = float3(c.r+cos(time)/30.0, c.g, 1) / 64.0;
    float  m = 1.0;
	float  t = 0.0;
	
    for(int j=0;j<333;j++)
    {
        if( m > 0.4)
		{
            t = (1.0 + float(j)) * 2.0;
   			m = e(o + g * t);
		}
    }
	
	
    float3 r = float3(0.1, 0.0, 0.0);
	float3 n = m - float3( e( float3(o+g*t+r.rgg) ),
                   		   e( float3(o+g*t+r.grg) ),
                   		   e( float3(o+g*t+r.ggr) ) );
	
    float3 v = dot(float3(0, 0, -0.5), n) + dot(float3(0.0, -0.5, 0.5), n) ;
	
	
	return  float4(v + float3(0.1 + cos(time/14.)/8.0, 0.1, 0.1 - cos(time/3.0)/19.0) * (t/41.0), 0);
	
	
}

technique10 Nautilus
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PSNautilus() ) );
	}
}
technique10 Nautilus_Original
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSNautilusOrig() ) );
	}
}




