//@author: sebl
//@help: a shader for 2D clouds
//@tags: raymarching, shadertoy
//@credits: inigo quilez - iq/2013
//@license: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.



float2 R:TARGETSIZE;

cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	
	float iGlobalTime = 0.0;
	
//	float3(0.2,0.1,0.4), float3(0.3,0.05,0.05)
	
	float4 c1 <bool color=true;String uiname="Color1";> = { 0.2f, 0.1f, 0.4f, 1.0f };
	float4 c2 <bool color=true;String uiname="Color2";> = { 0.3f, 0.05f, 0.05f, 1.0f };


	float4 c3 <bool color=true;String uiname="Color3";> = { 0.9f, 0.9f, 0.9f, 1.0f };
	float4 c4 <bool color=true;String uiname="Color4";> = { 0.4f, 0.3f, 0.3f, 1.0f };
	float4 c5 <bool color=true;String uiname="Color5";> = { 0.0f, 0.2f, 0.4f, 1.0f };
	
	float4 c6 <bool color=true;String uiname="Color6";> = { 0.7f, 0.9f, 0.95f, 1.0f };
	float4 c7 <bool color=true;String uiname="Color7";> = { 0.15f, 0.1f, 0.05f, 1.0f };
	
//	float4 c6 <bool color=true;String uiname="Color6";> = { 1.0f,1.0f,1.0f,1.0f };
//	float4 c7 <bool color=true;String uiname="Color7";> = { 1.0f,1.0f,1.0f,1.0f };
//	float4 c8 <bool color=true;String uiname="Color8";> = { 1.0f,1.0f,1.0f,1.0f };


};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;
	
};

struct vs2ps
{
	float4 PosWVP: SV_POSITION;
	float4 TexCd: TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
	vs2ps output;
	output.PosWVP  = mul(input.PosO,mul(tW,tVP));
	output.TexCd = input.TexCd;
	return output;
}

/*******************************************************************************
METHODS
*******************************************************************************/
static const float2x2 m = float2x2( 0.80,  0.60, -0.60,  0.80 );

float noise( in float2 x )
{
	return sin(1.5*x.x)*sin(1.5*x.y);
}

float fbm4( float2 p )
{
    float f = 0.0;
    f += 0.5000*noise( p ); p = mul(m , p) * 2.02;
    f += 0.2500*noise( p ); p = mul(m , p) * 2.03;
    f += 0.1250*noise( p ); p = mul(m , p) * 2.01;
    f += 0.0625*noise( p );
    return f/0.9375;
}

float fbm6( float2 p )
{
    float f = 0.0;

	f += 0.500000*(0.5+0.5*noise( p )); p = mul(m , p) * 2.02;
    f += 0.250000*(0.5+0.5*noise( p )); p = mul(m , p) * 2.03;
    f += 0.125000*(0.5+0.5*noise( p )); p = mul(m , p) * 2.01;
    f += 0.062500*(0.5+0.5*noise( p )); p = mul(m , p) * 2.04;
    f += 0.031250*(0.5+0.5*noise( p )); p = mul(m , p) * 2.01;
    f += 0.015625*(0.5+0.5*noise( p ));
    return f/0.96875;
}

float func( float2 q, out float4 ron )
{
    float ql = length( q );
    q.x += 0.05*sin(0.27*iGlobalTime+ql*4.1);
    q.y += 0.05*sin(0.23*iGlobalTime+ql*4.3);
    q *= 0.5;

	float2 o = float2(0.0, 0.0);
    o.x = 0.5 + 0.5*fbm4( float2(2.0*q          )  );
    o.y = 0.5 + 0.5*fbm4( float2(2.0*q+float2(5.2, 5.2))  );

	float ol = length( o );
    o.x += 0.02*sin(0.12*iGlobalTime+ol)/ol;
    o.y += 0.02*sin(0.14*iGlobalTime+ol)/ol;

    float2 n;
    n.x = fbm6( float2(4.0*o+float2(9.2, 9.2))  );
    n.y = fbm6( float2(4.0*o+float2(5.7, 5.7))  );

    float2 p = 4.0*q + 4.0*n;

    float f = 0.5 + 0.5*fbm4( p );

    f = lerp( f, f*f*f*3.5, f*abs(n.x) );

    float g = 0.5 + 0.5*sin(4.0*p.x)*sin(4.0*p.y);
    f *= 1.0-0.5*pow( g, 8.0 );

	ron = float4( o, n );
	
    return f;
}

float3 doMagic(float2 p)
{
	float2 q = p*0.6;

    float4 on = float4(0.0, 0.0, 0.0, 0.0);
    float f = func(q, on);

	float3 col = float3(0.0, 0.0, 0.0);
//    col = lerp( float3(0.2,0.1,0.4), float3(0.3,0.05,0.05), f );
    col = lerp( c1.rgb, c2.rgb, f );
//    col = lerp( col, float3(0.9,0.9,0.9), dot(on.zw,on.zw) );
//    col = lerp( col, float3(0.4,0.3,0.3), 0.5*on.y*on.y );
//    col = lerp( col, float3(0.0,0.2,0.4), 0.5*smoothstep(1.2,1.3,abs(on.z)+abs(on.w)) );
    col = lerp( col, c3.rgb, dot(on.zw,on.zw) );
    col = lerp( col, c4.rgb, 0.5*on.y*on.y );
    col = lerp( col, c5.rgb, 0.5*smoothstep(1.2,1.3,abs(on.z)+abs(on.w)) );
    col = clamp( col*f*2.0, 0.0, 1.0 );
    
	float3 nor = normalize( float3( ddx(f)* R.x, 6.0, ddy(f)*R.y ) );

    float3 lig = normalize( float3( 0.9, -0.2, -0.4 ) );
    float dif = clamp( 0.3+0.7*dot( nor, lig ), 0.0, 1.0 );
    float3 bdrf;
    bdrf  = c6.rgb *(nor.y*0.5+0.5);
    bdrf += c7.rgb*dif;
    col *= 1.2*bdrf;
	col = 1.0-col;
	return 1.1*col*col;
}
/*******************************************************************************
PS
*******************************************************************************/

float4 PSclouds(vs2ps In): SV_Target
{
	float2 q = 1 -In.TexCd.rg;
	float2 p = -1.0 + 2.0*q;
	p.x *= R.x / R.y;
	
	return  float4(doMagic( p ), 1.0 );
	
}

/*******************************************************************************
TECHNIQUES
*******************************************************************************/

technique10 Warp
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PSclouds() ) );
	}
}






