//@author: sebl
//@help: a shader for 2D clouds
//@tags: raymarching, shadertoy
//@credits: inigo quilez - iq/2013
//@license: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.


Texture2D texture2d <string uiname="Texture";>;

SamplerState linearSampler : IMMUTABLE
{
	Filter = MIN_MAG_MIP_LINEAR;
	//	Filter = Anisotropic;
	AddressU = Wrap;
	AddressV = Wrap;
};

//StructuredBuffer<float2> noises;

float2 R:TARGETSIZE;

cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	
	float time = 0.0;
	float2 iMouse = float2(0.0, 0.0);
	
	float3 sundir = float3(-1.0,0.0,0.0);
	float sunsize = 4.0;
	
	float4 c1 <bool color=true;String uiname="Color1";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 c2 <bool color=true;String uiname="Color2";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 c3 <bool color=true;String uiname="Color3";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 c4 <bool color=true;String uiname="Color4";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 c5 <bool color=true;String uiname="Color5";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 c6 <bool color=true;String uiname="Color6";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 c7 <bool color=true;String uiname="Color7";> = { 1.0f,1.0f,1.0f,1.0f };
	float4 c8 <bool color=true;String uiname="Color8";> = { 1.0f,1.0f,1.0f,1.0f };
	
	float4 coeffs;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;
	
};

struct vs2ps
{
	float4 PosWVP: SV_POSITION;
	float4 TexCd: TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
	vs2ps output;
	output.PosWVP  = mul(input.PosO,mul(tW,tVP));
	output.TexCd = input.TexCd;
	return output;
}

#define FULL_PROCEDURAL

/*******************************************************************************
NOISE
*******************************************************************************/

#ifdef FULL_PROCEDURAL

// hash based 3d value noise
float hash( float n )
{
	return frac(sin(n)*43758.5453);
}
float noise( in float3 x )
{
	float3 p = floor(x);
	float3 f = frac(x);
	
	f = f*f*(3.0-2.0*f);
	float n = p.x + p.y*57.0 + 113.0*p.z;
	return lerp(lerp(lerp( hash(n+  0.0), hash(n+  1.0),f.x),
	lerp( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
	lerp(lerp( hash(n+113.0), hash(n+114.0),f.x),
	lerp( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
}
#else

// LUT based 3d value noise
float noise( in float3 x )
{
	float3 p = floor(x);
	float3 f = frac(x);
	f = f*f*(3.0-2.0*f);
	
	float2 uv = (p.xy + float2(37.0, 17.0) * p.z) + f.xy;
	//	uv = (p.xy + p.z) + f.xy;
	//	float2 uv = p.xy;
	
	//float2 rg = texture2d.SampleLevel(linearSampler, (uv+0.5)/256.0, 0 ).yx;
	
	//---------------------------------------------
	// better texture filtering by filtering the uv-coords
	//---------------------------------------------
	float textureResolution = 256.0;
	uv = uv*textureResolution/* + 0.5*/;
	float2 iuv = floor( uv );
	float2 fuv = frac( uv );
	uv = iuv + fuv*fuv*(3.0-2.0*fuv);
	//uv = iuv + fuv*fuv*fuv*(fuv*(fuv*6.0-15.0)+10.0);
	uv = uv/textureResolution;
	uv /= 100;
	float2 rg = texture2d.SampleLevel(linearSampler, uv , 0 ).xy;
	
	/*   --- version with a buffer instead of texture ---
	uint count,dummy;
	noises.GetDimensions(count,dummy);
	
	float n = p.x + p.y * p.z;
	
	float col = (uv.x+ 0.5) * count;
	float row = (uv.y+ 0.5) * count;
	
	float pos = col+row*count;
	
	float2 rg = noises[pos];
	*/
	
	return lerp( rg.x, rg.y, f.z );
}

#endif

/*******************************************************************************
METHODS
*******************************************************************************/

float4 map( in float3 p )
{
	float d = 0.2 - p.y;
	
	float3 q = p - float3(1.0,0.1,0.0)*time;
	float f;
	f  = 0.5000*noise( q ); q = q * coeffs.x;
	f += 0.2500*noise( q ); q = q * coeffs.y;
	f += 0.1250*noise( q ); q = q * coeffs.z;
	f += 0.0625*noise( q ); q = q;
	
	d += 3.0 * f;
	
	d = clamp( d, 0.0, 1.0 );
	
	float4 res = float4( d, d, d, d );
	
	res.xyz = lerp( 1.15 * c7.rgb, c8.rgb, res.x );
	
	return res;
}

float4 raymarch( in float3 ro, in float3 rd )
{
	float4 sum = float4(0, 0, 0, 0);
	
	float t = 0.0;
	for(int i=0; i<64; i++)
	{
		if( sum.a > 0.99 ) continue;
		
		float3 pos = ro + t*rd;
		float4 col = map( pos );
		
		#if 1
		float dif =  clamp((col.w - map(pos+0.3*sundir).w)/0.6, 0.0, 1.0 );
		
		float3 lin = c5.rgb * 1.35 + 0.45 * c6.rgb * dif;
		col.xyz *= lin;
		#endif
		
		col.a *= 0.35;
		col.rgb *= col.a;
		
		sum = sum + col*(1.0 - sum.a);
		
		#if 0
		t += 0.1;
		#else
		t += max(0.1,0.025*t);
		#endif
	}
	
	sum.xyz /= (0.001+sum.w);
	
	return clamp( sum, 0.0, 1.0 );
}

/*******************************************************************************
PS
*******************************************************************************/

float4 PSclouds(vs2ps In): SV_Target
{
	float2 q = 1 -In.TexCd.rg;
	float2 p = -1.0 + 2.0*q;
	p.x *= R.x / R.y;
	float2 mo = -1.0 + 2.0*iMouse.xy ;
	
	// camera
	float3 ro = 4.0*normalize(float3(cos(2.75-3.0*mo.x), 0.7+(mo.y+1.0), sin(2.75-3.0*mo.x)));
	float3 ta = float3(0.0, 1.0, 0.0);
	float3 ww = normalize( ta - ro);
	float3 uu = normalize(cross( float3(0.0,1.0,0.0), ww ));
	float3 vv = normalize(cross(ww,uu));
	float3 rd = normalize( p.x*uu + p.y*vv + 1.5*ww );
	
	float4 res = raymarch( ro, rd );
	
	float sun = clamp( dot(sundir, rd / sunsize), 0.0, 1.0 );
	float3 col = c1.rgb - rd.y * 0.2 * c2.rgb + 0.15 * 0.5;
	col += 0.2 * c3.rgb * pow( sun, 2.0 );
	col *= 0.95;
	col = lerp( col, res.xyz, res.w );
	col += 0.1 * c4.rgb * pow( sun, 3.0 );
	
	return  float4( col, 1.0 );
}

/*******************************************************************************
TECHNIQUES
*******************************************************************************/

technique10 Clouds
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSclouds() ) );
	}
}






