// http://www.fractalforums.com/movies-showcase-%28rate-my-movie%29/very-rare-deep-sea-fractal-creature/

float2 R:TARGETSIZE;
Texture2D tex0 <string uiname="Texture";>;
SamplerState s0 <bool visible=false;string uiname="Sampler";> 
{
	Filter=MIN_MAG_MIP_LINEAR;
	AddressU=wrap;
	AddressV=wrap;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float Time;
int Iterations=16;
float Scale=1.27;
float3 Julia=float3(-2.,-1.5,-.5);
float3 RotVector=float3(0.5,-0.05,-0.5);
float RotAngle=145.;
float Speed=1.3;
float Amplitude=0.25;
float detail=.075;
float3 lightdir=-float3(0.5,1.,0.5);
};


float2x2 rot;

float de(float3 p); 

float3 normal(float3 p) {
	float3 e = float3(0.0,detail,0.0);
	
	return normalize(float3(
			de(p+e.yxx)-de(p-e.yxx),
			de(p+e.xyx)-de(p-e.xyx),
			de(p+e.xxy)-de(p-e.xxy)
			)
		);	
}

float softshadow( in float3 ro, in float3 rd, float mint, float k )
{
    float res = 1.0;
    float t = mint;
    for( int i=0; i<48; i++ )
    {
        float h = de(ro + rd*t);
		h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.01, 0.5 );
    }
    return clamp(res,0.0,1.0);
}

float4 light(in float3 p, in float3 dir,float d)
{
	float4 lightCol;
	float3 ldir=normalize(lightdir);
	float3 n=normal(p);
	float sh=softshadow(p,-ldir,1.,20.);
	float diff=max(0.,dot(ldir,-n));
	float3 r = reflect(ldir,n);
	float spec=max(0.,dot(dir,-r));
	float3 ray = .8*d*((0.4*p-3.*r)+d*float3(1.0,1.0,1.0));
	lightCol = tex0.Sample(s0,ray.xz+ray.xy);
	return 3.0*lightCol*diff*sh+pow(spec,30.)*.5*sh+.15*max(0.,dot(normalize(dir),-n));	
		}

float4 raymarch(in float3 from, in float3 dir)
{
	float st,d=1.0,totdist=st=0.;
	float3 p;
	float4 col;
	for (int i=0; i<30; i++) 
	{
		if (d>detail && totdist<150.)
		{
			p=from+totdist*dir;
			d=de(p);
			totdist+=d;
		}
	}
	float4 backg=float4(0.,0.,0.,0.);
	if (d<detail) {
		col=light(p, dir,d); 
	} else { 
		col=backg;
	}
	col = col;//mix(col, backg, 1.0-exp(-.000025*pow(totdist,3.5)));
	return col;
}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
   float t=Time*.3;
	float2 uv = 1-2*In.TexCd.xy;
	uv.y*=R.y/R.x;
	float3 from=float3(0.,-.7,-20.);
	float3 dir=normalize(float3(uv*.7,1.));
	float rot=float4(cos(-.5),sin(-.5),-sin(-.5),cos(-.5));
	dir.yz=dir.yz*rot;
	from.yz=from.yz*rot;

	float4 col=raymarch(from,dir); 
	return col;
}

float3x3  rotationMatrix3(float3 v, float angle)
{
	float c = cos(radians(angle));
	float s = sin(radians(angle));
	
	return float3x3(c + (1.0 - c) * v.x * v.x, (1.0 - c) * v.x * v.y - s * v.z, (1.0 - c) * v.x * v.z + s * v.y,
		(1.0 - c) * v.x * v.y + s * v.z, c + (1.0 - c) * v.y * v.y, (1.0 - c) * v.y * v.z - s * v.x,
		(1.0 - c) * v.x * v.z - s * v.y, (1.0 - c) * v.y * v.z + s * v.x, c + (1.0 - c) * v.z * v.z
		);
}


float de(float3 p) {
	p=p.zxy;
	float a=1.5+sin(Time*.5)*.5;
	p.xy=mul(p.xy,float2x2(cos(a),sin(a),-sin(a),cos(a)));
	p.x*=.75;
	float time=Time*Speed;
	float3 ani;
	ani=float3(sin(time),sin(time),cos(time))*Amplitude;
	p+=sin(p*3.+time*6.)*.04;
	float3x3 rot = rotationMatrix3(normalize(RotVector+ani), RotAngle+sin(time)*10.);
	float3 pp=p;
	float l;
	for (int i=0; i<Iterations; i++) {
		p.xy=abs(p.xy);
		p=p*Scale+Julia;
		p=mul(p,rot);
		l=length(p);
	}
	return l*pow(abs(Scale), -float(Iterations))*.9;
}


technique10 Avatar
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



